/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.parameter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class CommonParameter {
    protected String name = "";
    protected String description = "";
    protected String format = "";
    protected String valueString = "";
    protected int textAlignment = 2;
    protected FocusListener textfieldListener = null;
    protected Color backgroundColor = Color.WHITE;

    public int getAlignment() {
        return this.textAlignment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public abstract void setValueString(String var1);

    protected abstract void valueToString();

    public abstract String getValueString();

    protected void makeListener() {
        this.textfieldListener = new FocusListener(){
            String previous = "";

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.previous = ((JTextField)focusEvent.getSource()).getText();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                try {
                    CommonParameter.this.setValueString(jTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.setText(this.previous);
                }
            }
        };
    }

    public JPanel getGuiComponent() {
        return this.getGuiComponent(null);
    }

    public JPanel getGuiComponent(Dimension dimension) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new FlowLayout(2));
        JLabel jLabel = new JLabel(this.description);
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setHorizontalAlignment(this.textAlignment);
        if (dimension != null) {
            jTextField.setPreferredSize(dimension);
        }
        this.valueToString();
        jTextField.setText(this.valueString);
        if (this.textfieldListener == null) {
            this.makeListener();
            jTextField.addFocusListener(this.textfieldListener);
        }
        jPanel.add(jTextField);
        return jPanel;
    }
}

