/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.swing;

import eu.fuegenstein.swing.NamedColor;
import eu.fuegenstein.swing.PlainColorIcon;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class CustomColorChooserPanel
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = 5669951982671747823L;
    private List<NamedColor> colors = new ArrayList<NamedColor>();
    private String displayName = "Palette";
    private MouseAdapter mouseListener = null;

    public CustomColorChooserPanel() {
        this.setLayout(new FlowLayout(1));
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getSource() instanceof JLabel) {
                    PlainColorIcon plainColorIcon = (PlainColorIcon)((JLabel)mouseEvent.getSource()).getIcon();
                    CustomColorChooserPanel.this.getColorSelectionModel().setSelectedColor(plainColorIcon.getColor());
                }
            }
        };
    }

    public List<NamedColor> getColors() {
        return this.colors;
    }

    public void setColors(List<NamedColor> list) {
        this.colors = list;
        this.make();
    }

    public void addColor(NamedColor namedColor) {
        this.colors.add(namedColor);
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
    }

    private void make() {
        for (NamedColor namedColor : this.colors) {
            JLabel jLabel = new JLabel(new PlainColorIcon(namedColor));
            jLabel.setToolTipText(namedColor.getName());
            jLabel.setBorder(BorderFactory.createEtchedBorder());
            jLabel.addMouseListener(this.mouseListener);
            this.add(jLabel);
        }
    }
}

