/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.unit;

import eu.fuegenstein.unit.Unit;
import eu.fuegenstein.unit.UnitFoot;
import eu.fuegenstein.unit.UnitKilometer;
import eu.fuegenstein.unit.UnitMeter;
import eu.fuegenstein.unit.UnitMile;
import eu.fuegenstein.unit.UnitNauticalMile;
import eu.fuegenstein.unit.UnitSet;

public class UnitFactory {
    public static final Unit METER = new UnitMeter();
    public static final Unit KILOMETER = new UnitKilometer();
    public static final Unit METERS_PER_SECOND = new Unit("Meters per second", "m/s", 1.0, METER);
    public static final Unit KILOMETERS_PER_HOUR = new Unit("Kilometers per hour", "km/h", 3600.0, KILOMETER);
    public static final Unit METERS_PER_HOUR = new Unit("Meters per hour", "m/hr", 3600.0, METER);
    public static final Unit FOOT = new UnitFoot();
    public static final Unit MILE = new UnitMile();
    public static final Unit MILES_PER_HOUR = new Unit("Miles per hour", "mph", 3600.0, MILE);
    public static final Unit FEET_PER_HOUR = new Unit("Feet per hour", "ft/hr", 3600.0, FOOT);
    public static final Unit NAUTICAL_MILE = new UnitNauticalMile();
    public static final Unit KNOTS = new Unit("Knots", "kn", 3600.0, NAUTICAL_MILE);

    public static UnitSet getMetricSet() {
        UnitSet unitSet = new UnitSet();
        unitSet.setDistanceUnit(METER);
        unitSet.setSpeedUnit(METERS_PER_SECOND);
        unitSet.setElevationUnit(METER);
        unitSet.setVerticalSpeedUnit(METERS_PER_SECOND);
        return unitSet;
    }
}

