/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.event;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.sentence.Sentence;

public abstract class AbstractSentenceListener<T extends Sentence>
implements SentenceListener {
    private final Type expectedType;

    public AbstractSentenceListener() {
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] superClassTypeArgs = superClass.getActualTypeArguments();
        this.expectedType = superClassTypeArgs[0];
    }

    @Override
    public void readingPaused() {
    }

    @Override
    public void readingStarted() {
    }

    @Override
    public void readingStopped() {
    }

    public abstract void sentenceRead(T var1);

    @Override
    public void sentenceRead(SentenceEvent event) {
        Sentence sentence = event.getSentence();
        Class<?>[] interfaces = sentence.getClass().getInterfaces();
        if (Arrays.asList(interfaces).contains(this.expectedType)) {
            this.sentenceRead(sentence);
        }
    }
}

