/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.marineapi.nmea.io.ActivityMonitor;
import net.sf.marineapi.nmea.io.DataReader;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.parser.SentenceFactory;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceValidator;

abstract class AbstractDataReader
implements DataReader {
    private static final Logger LOG = Logger.getLogger(AbstractDataReader.class.getName());
    private final SentenceReader parent;
    private volatile boolean isRunning = true;

    public AbstractDataReader(SentenceReader parent) {
        this.parent = parent;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void run() {
        ActivityMonitor monitor = new ActivityMonitor(this.parent);
        SentenceFactory factory = SentenceFactory.getInstance();
        while (this.isRunning) {
            try {
                String data = this.read();
                if (SentenceValidator.isValid(data)) {
                    monitor.refresh();
                    Sentence s = factory.createParser(data);
                    this.parent.fireSentenceEvent(s);
                }
                monitor.tick();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Data read failed", e);
            }
        }
        monitor.reset();
        this.parent.fireReadingStopped();
    }

    public abstract String read();
}

