/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import net.sf.marineapi.nmea.io.SentenceReader;

class ActivityMonitor {
    private long lastUpdated = -1L;
    private SentenceReader parent;

    public ActivityMonitor(SentenceReader parent) {
        this.parent = parent;
    }

    public void reset() {
        this.lastUpdated = -1L;
    }

    public void refresh() {
        if (this.lastUpdated < 0L) {
            this.parent.fireReadingStarted();
        }
        this.lastUpdated = System.currentTimeMillis();
    }

    public void tick() {
        int timeout;
        long elapsed;
        if (this.lastUpdated > 0L && (elapsed = System.currentTimeMillis() - this.lastUpdated) >= (long)(timeout = this.parent.getPauseTimeout())) {
            this.parent.fireReadingPaused();
            this.reset();
        }
    }
}

