/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import java.io.InputStream;
import java.net.DatagramSocket;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.DataReader;
import net.sf.marineapi.nmea.io.DefaultDataReader;
import net.sf.marineapi.nmea.io.UDPDataReader;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;

public class SentenceReader {
    public static final int DEFAULT_TIMEOUT = 5000;
    private static final String DISPATCH_ALL = "DISPATCH_ALL";
    private static final Logger LOGGER = Logger.getLogger(SentenceReader.class.getName());
    private static final String LOG_MSG = "Exception caught from SentenceListener";
    private Thread thread;
    private DataReader reader;
    private ConcurrentMap<String, List<SentenceListener>> listeners = new ConcurrentHashMap<String, List<SentenceListener>>();
    private volatile int pauseTimeout = 5000;

    public SentenceReader(InputStream source) {
        this.reader = new DefaultDataReader(source, this);
    }

    public SentenceReader(DatagramSocket source) {
        this.reader = new UDPDataReader(source, this);
    }

    public void addSentenceListener(SentenceListener listener) {
        this.registerListener(listener, DISPATCH_ALL);
    }

    public void addSentenceListener(SentenceListener sl, SentenceId type) {
        this.registerListener(sl, type.toString());
    }

    public void addSentenceListener(SentenceListener sl, String type) {
        this.registerListener(sl, type);
    }

    public int getPauseTimeout() {
        return this.pauseTimeout;
    }

    public void removeSentenceListener(SentenceListener listener) {
        for (List list : this.listeners.values()) {
            if (!list.contains(listener)) continue;
            list.remove(listener);
        }
    }

    public void setInputStream(InputStream stream) {
        if (this.reader.isRunning()) {
            this.stop();
        }
        this.reader = new DefaultDataReader(stream, this);
    }

    public void setDatagramSocket(DatagramSocket socket) {
        if (this.reader.isRunning()) {
            this.stop();
        }
        this.reader = new UDPDataReader(socket, this);
    }

    public void setPauseTimeout(int millis) {
        this.pauseTimeout = millis;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive() && this.reader != null && this.reader.isRunning()) {
            throw new IllegalStateException("Reader is already running");
        }
        this.thread = new Thread(this.reader);
        this.thread.start();
    }

    public void stop() {
        if (this.reader != null && this.reader.isRunning()) {
            this.reader.stop();
        }
    }

    void fireReadingPaused() {
        for (List l : this.listeners.values()) {
            for (SentenceListener listener : l) {
                try {
                    listener.readingPaused();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LOG_MSG, e);
                }
            }
        }
    }

    void fireReadingStarted() {
        for (List l : this.listeners.values()) {
            for (SentenceListener listener : l) {
                try {
                    listener.readingStarted();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LOG_MSG, e);
                }
            }
        }
    }

    void fireReadingStopped() {
        for (List l : this.listeners.values()) {
            for (SentenceListener listener : l) {
                try {
                    listener.readingStopped();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LOG_MSG, e);
                }
            }
        }
    }

    void fireSentenceEvent(Sentence sentence) {
        String type = sentence.getSentenceId();
        HashSet targets = new HashSet();
        if (this.listeners.containsKey(type)) {
            targets.addAll((Collection)this.listeners.get(type));
        }
        if (this.listeners.containsKey(DISPATCH_ALL)) {
            targets.addAll((Collection)this.listeners.get(DISPATCH_ALL));
        }
        for (SentenceListener listener : targets) {
            try {
                SentenceEvent se = new SentenceEvent(this, sentence);
                listener.sentenceRead(se);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LOG_MSG, e);
            }
        }
    }

    private void registerListener(SentenceListener listener, String type) {
        if (this.listeners.containsKey(type)) {
            ((List)this.listeners.get(type)).add(listener);
        } else {
            Vector<SentenceListener> list = new Vector<SentenceListener>();
            list.add(listener);
            this.listeners.put(type, list);
        }
    }
}

