/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.marineapi.nmea.io.AbstractDataReader;
import net.sf.marineapi.nmea.io.SentenceReader;

class UDPDataReader
extends AbstractDataReader {
    private static final Logger LOG = Logger.getLogger(UDPDataReader.class.getName());
    private DatagramSocket socket;
    private byte[] buffer = new byte[1024];

    public UDPDataReader(DatagramSocket socket, SentenceReader parent) {
        super(parent);
        this.socket = socket;
    }

    @Override
    public String read() {
        String data = null;
        try {
            DatagramPacket pkg = new DatagramPacket(this.buffer, this.buffer.length);
            this.socket.receive(pkg);
            data = new String(pkg.getData(), 0, pkg.getLength());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "UDP read failed", e);
        }
        return data;
    }
}

