/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.GLLSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;

class GLLParser
extends PositionParser
implements GLLSentence {
    private static final int LATITUDE = 0;
    private static final int LAT_HEMISPHERE = 1;
    private static final int LONGITUDE = 2;
    private static final int LON_HEMISPHERE = 3;
    private static final int UTC_TIME = 4;
    private static final int DATA_STATUS = 5;

    public GLLParser(String nmea) {
        super(nmea, SentenceId.GLL);
    }

    public GLLParser(TalkerId talker) {
        super(talker, SentenceId.GLL, 6);
    }

    @Override
    public Position getPosition() {
        return this.parsePosition(0, 1, 2, 3);
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(5));
    }

    @Override
    public Time getTime() {
        String str = this.getStringValue(4);
        return new Time(str);
    }

    @Override
    public void setPosition(Position pos) {
        this.setPositionValues(pos, 0, 1, 2, 3);
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(5, status.toChar());
    }

    @Override
    public void setTime(Time t) {
        this.setStringValue(4, t.toString());
    }
}

