/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.VTGSentence;
import net.sf.marineapi.nmea.util.FaaMode;

class VTGParser
extends SentenceParser
implements VTGSentence {
    private static final int TRUE_COURSE = 0;
    private static final int TRUE_INDICATOR = 1;
    private static final int MAGNETIC_COURSE = 2;
    private static final int MAGNETIC_INDICATOR = 3;
    private static final int SPEED_KNOTS = 4;
    private static final int KNOTS_INDICATOR = 5;
    private static final int SPEED_KMPH = 6;
    private static final int KMPH_INDICATOR = 7;
    private static final int MODE = 8;

    public VTGParser(String nmea) {
        super(nmea, SentenceId.VTG);
    }

    public VTGParser(TalkerId talker) {
        super(talker, SentenceId.VTG, 9);
        this.setCharValue(1, 'T');
        this.setCharValue(3, 'M');
        this.setCharValue(5, 'N');
        this.setCharValue(7, 'K');
    }

    @Override
    public double getMagneticCourse() {
        return this.getDoubleValue(2);
    }

    @Override
    public FaaMode getMode() {
        return FaaMode.valueOf(this.getCharValue(8));
    }

    @Override
    public double getSpeedKmh() {
        return this.getDoubleValue(6);
    }

    @Override
    public double getSpeedKnots() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getTrueCourse() {
        return this.getDoubleValue(0);
    }

    @Override
    public void setMagneticCourse(double mcog) {
        this.setDegreesValue(2, mcog);
    }

    @Override
    public void setMode(FaaMode mode) {
        this.setCharValue(8, mode.toChar());
    }

    @Override
    public void setSpeedKmh(double kmh) {
        if (kmh < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.setDoubleValue(6, kmh, 1, 2);
    }

    @Override
    public void setSpeedKnots(double knots) {
        if (knots < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.setDoubleValue(4, knots, 1, 2);
    }

    @Override
    public void setTrueCourse(double tcog) {
        this.setDegreesValue(0, tcog);
    }
}

