/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.WPLSentence;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Waypoint;

class WPLParser
extends PositionParser
implements WPLSentence {
    private static final int LATITUDE = 0;
    private static final int LAT_HEMISPHERE = 1;
    private static final int LONGITUDE = 2;
    private static final int LON_HEMISPHERE = 3;
    private static final int WAYPOINT_ID = 4;

    public WPLParser(String nmea) {
        super(nmea, SentenceId.WPL);
    }

    public WPLParser(TalkerId talker) {
        super(talker, SentenceId.WPL, 5);
    }

    @Override
    public Waypoint getWaypoint() {
        String id = this.getStringValue(4);
        Position p = this.parsePosition(0, 1, 2, 3);
        return p.toWaypoint(id);
    }

    @Override
    public void setWaypoint(Waypoint wp) {
        this.setStringValue(4, wp.getId());
        this.setPositionValues(wp, 0, 1, 2, 3);
    }
}

