/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.sentence;

import net.sf.marineapi.nmea.sentence.SentenceValidator;

public enum SentenceId {
    BOD,
    DBT,
    DPT,
    GGA,
    GLL,
    GSA,
    GSV,
    HDG,
    HDM,
    HDT,
    MTA,
    MTW,
    MWV,
    RMB,
    RMC,
    ROT,
    RTE,
    VTG,
    VHW,
    WPL,
    XDR,
    ZDA;


    public static SentenceId parse(String nmea) {
        String sid = SentenceId.parseStr(nmea);
        return SentenceId.valueOf(sid);
    }

    public static String parseStr(String nmea) {
        if (!SentenceValidator.isSentence(nmea)) {
            throw new IllegalArgumentException("String is not a sentence");
        }
        String id = null;
        id = nmea.startsWith("$P") ? nmea.substring(2, nmea.indexOf(44)) : nmea.substring(3, nmea.indexOf(44));
        return id;
    }
}

