/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointComparator;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Core {
    private int requestChunkSize = 200;
    private boolean isCancelled = false;
    public static final int SEG_TRACK = 0;
    public static final int SEG_ROUTE = 1;
    public static final int SEG_WAYPOINTS = 2;
    public static final int SEG_ROUTE_TRACK = 3;
    public static final int SEG_TRACK_ROUTE_WAYPOINTS = 4;
    public static final int SEG_TRACK_WAYPOINTS = 5;
    public static final int SEG_ROUTE_WAYPOINTS = 6;
    public static final int SEG_ALL = 7;

    public int getRequestChunkSize() {
        return this.requestChunkSize;
    }

    public void setRequestChunkSize(int n) {
        this.requestChunkSize = n;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void localToUtc(WaypointGroup waypointGroup) {
        for (Waypoint waypoint : waypointGroup.getWaypoints()) {
            if (waypoint.getTime() == null) continue;
            DateTime dateTime = new DateTime((Object)waypoint.getTime()).toDateTime(DateTimeZone.UTC);
            waypoint.setTime(dateTime.toDate());
        }
    }

    public static void clearTimestamps(WaypointGroup waypointGroup) {
        for (Waypoint waypoint : waypointGroup.getWaypoints()) {
            waypoint.setTime(null);
        }
    }

    public static void clearTimestamps(List<WaypointGroup> list) {
        for (WaypointGroup waypointGroup : list) {
            Core.clearTimestamps(waypointGroup);
        }
    }

    public static void timeShiftDelta(WaypointGroup waypointGroup, long l) {
        if (waypointGroup != null) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                if (waypoint.getTime() == null) continue;
                Date date = new Date(waypoint.getTime().getTime() + l);
                waypoint.setTime(date);
            }
        }
    }

    public List<WaypointGroup> getWaypointGroup(GPXObject gPXObject) {
        WaypointGroup waypointGroup;
        ArrayList<WaypointGroup> arrayList = new ArrayList<WaypointGroup>();
        if (gPXObject instanceof GPXFile) {
            GPXFile gPXFile = (GPXFile)gPXObject;
            if (gPXFile.getWaypointGroup().getWaypoints().size() > 0) {
                arrayList.add(gPXFile.getWaypointGroup());
            }
        } else if (gPXObject instanceof WaypointGroup && (waypointGroup = (WaypointGroup)gPXObject).getWptGrpType() == WaypointGroup.WptGrpType.WAYPOINTS && waypointGroup.getWaypoints().size() > 0) {
            arrayList.add(waypointGroup);
        }
        return arrayList;
    }

    public List<WaypointGroup> getTrackSegments(GPXObject gPXObject) {
        WaypointGroup waypointGroup;
        ArrayList<WaypointGroup> arrayList = new ArrayList<WaypointGroup>();
        if (gPXObject instanceof GPXFile) {
            GPXFile gPXFile = (GPXFile)gPXObject;
            for (Track track : gPXFile.getTracks()) {
                arrayList.addAll(track.getTracksegs());
            }
        } else if (gPXObject instanceof Track) {
            arrayList.addAll(((Track)gPXObject).getTracksegs());
        } else if (gPXObject instanceof WaypointGroup && (waypointGroup = (WaypointGroup)gPXObject).getWptGrpType() == WaypointGroup.WptGrpType.TRACKSEG) {
            arrayList.add(waypointGroup);
        }
        return arrayList;
    }

    public List<WaypointGroup> getRouteSegments(GPXObject gPXObject) {
        WaypointGroup waypointGroup;
        ArrayList<WaypointGroup> arrayList = new ArrayList<WaypointGroup>();
        if (gPXObject instanceof GPXFile) {
            GPXFile gPXFile = (GPXFile)gPXObject;
            for (Route route : gPXFile.getRoutes()) {
                arrayList.add(route.getPath());
            }
        } else if (gPXObject instanceof Route) {
            arrayList.add(((Route)gPXObject).getPath());
        } else if (gPXObject instanceof WaypointGroup && (waypointGroup = (WaypointGroup)gPXObject).getWptGrpType() == WaypointGroup.WptGrpType.ROUTE) {
            arrayList.add(waypointGroup);
        }
        return arrayList;
    }

    public List<WaypointGroup> getSegments(GPXObject gPXObject, int n) {
        ArrayList<WaypointGroup> arrayList = new ArrayList<WaypointGroup>();
        switch (n) {
            case 0: {
                arrayList.addAll(this.getTrackSegments(gPXObject));
                break;
            }
            case 1: {
                arrayList.addAll(this.getRouteSegments(gPXObject));
                break;
            }
            case 3: {
                arrayList.addAll(this.getTrackSegments(gPXObject));
                arrayList.addAll(this.getRouteSegments(gPXObject));
                break;
            }
            case 2: {
                arrayList.addAll(this.getWaypointGroup(gPXObject));
                break;
            }
            case 5: {
                arrayList.addAll(this.getTrackSegments(gPXObject));
                arrayList.addAll(this.getWaypointGroup(gPXObject));
                break;
            }
            case 6: {
                arrayList.addAll(this.getRouteSegments(gPXObject));
                arrayList.addAll(this.getWaypointGroup(gPXObject));
                break;
            }
            case 4: 
            case 7: {
                arrayList.addAll(this.getTrackSegments(gPXObject));
                arrayList.addAll(this.getRouteSegments(gPXObject));
                arrayList.addAll(this.getWaypointGroup(gPXObject));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return arrayList;
    }

    private void addTrackpoints(WaypointGroup waypointGroup, WaypointGroup waypointGroup2) {
        for (Waypoint waypoint : waypointGroup2.getWaypoints()) {
            waypointGroup.getWaypoints().add(new Waypoint(waypoint));
        }
    }

    private void addWaypoints(WaypointGroup waypointGroup, WaypointGroup waypointGroup2) {
        waypointGroup.getWaypoints().addAll(waypointGroup2.getWaypoints());
    }

    private void copyVisibleSegments(WaypointGroup waypointGroup, List<WaypointGroup> list) {
        for (WaypointGroup waypointGroup2 : list) {
            if (!waypointGroup2.isVisible()) continue;
            this.addTrackpoints(waypointGroup, waypointGroup2);
        }
    }

    public GPXFile mergeIntoTracks(List<GPXFile> list) {
        GPXFile gPXFile = new GPXFile();
        gPXFile.getMetadata().setName("Merged GPX");
        int n = 0;
        for (GPXFile gPXFile2 : list) {
            if (!gPXFile2.isVisible()) continue;
            for (Track track : gPXFile2.getTracks()) {
                if (!track.isVisible()) continue;
                Track track2 = new Track(track);
                track2.setNumber(++n);
                gPXFile.addTrack(track2);
            }
            if (!gPXFile2.getWaypointGroup().isVisible()) continue;
            this.addWaypoints(gPXFile.getWaypointGroup(), gPXFile2.getWaypointGroup());
        }
        Collections.sort(gPXFile.getWaypointGroup().getWaypoints(), new WaypointComparator());
        return gPXFile;
    }

    public GPXFile mergeIntoMulti(List<GPXFile> list) {
        GPXFile gPXFile = new GPXFile();
        gPXFile.getMetadata().setName("Merged GPX");
        Track track = new Track(gPXFile.getColor());
        for (GPXFile gPXFile2 : list) {
            if (!gPXFile2.isVisible()) continue;
            for (Track track2 : gPXFile2.getTracks()) {
                if (!track2.isVisible()) continue;
                for (WaypointGroup waypointGroup : track2.getTracksegs()) {
                    if (!waypointGroup.isVisible()) continue;
                    track.addTrackseg(new WaypointGroup(waypointGroup));
                }
            }
            if (!gPXFile2.getWaypointGroup().isVisible()) continue;
            this.addWaypoints(gPXFile.getWaypointGroup(), gPXFile2.getWaypointGroup());
        }
        if (track.getTracksegs().size() > 0) {
            gPXFile.addTrack(track);
        }
        return gPXFile;
    }

    public GPXFile mergeIntoSingle(List<GPXFile> list) {
        GPXFile gPXFile = new GPXFile();
        gPXFile.getMetadata().setName("Merged GPX");
        Track track = new Track(gPXFile.getColor());
        WaypointGroup waypointGroup = new WaypointGroup(gPXFile.getColor(), WaypointGroup.WptGrpType.TRACKSEG);
        for (GPXFile gPXFile2 : list) {
            if (!gPXFile2.isVisible()) continue;
            for (Track track2 : gPXFile2.getTracks()) {
                if (!track2.isVisible()) continue;
                this.copyVisibleSegments(waypointGroup, track2.getTracksegs());
            }
            if (!gPXFile2.getWaypointGroup().isVisible()) continue;
            this.addWaypoints(gPXFile.getWaypointGroup(), gPXFile2.getWaypointGroup());
        }
        if (waypointGroup.getWaypoints().size() > 0) {
            gPXFile.addTrack(track);
            Collections.sort(waypointGroup.getWaypoints(), new WaypointComparator());
            track.addTrackseg(waypointGroup);
        }
        return gPXFile;
    }

    public GPXFile mergeParallel(List<GPXFile> list) {
        GPXFile gPXFile = new GPXFile();
        return gPXFile;
    }
}

