/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import eu.fuegenstein.unit.UnitConverter;
import eu.fuegenstein.util.XTime;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.MeasurePoint;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.marker.MeasureMarker;
import org.gpsmaster.widget.DistanceWidget;

public class MeasureThings {
    private DistanceWidget widget = null;
    private PropertyChangeListener clickListener = null;
    private PropertyChangeListener changeListener = null;
    private List<WaypointGroup> groups = null;
    private List<MeasurePoint> points = new ArrayList<MeasurePoint>();
    private List<Marker> mapMarkers = null;
    private MessageCenter msg = null;
    private MessagePanel msgMeasure = null;
    private UnitConverter uc = null;
    private final String emptyText = "select two or more trackpoints.";
    private int c = 0;

    public MeasureThings(DistanceWidget distanceWidget, UnitConverter unitConverter, List<Marker> list) {
        this.widget = distanceWidget;
        this.uc = unitConverter;
        this.mapMarkers = list;
        this.clickListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("1click")) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof MeasureMarker) {
                        MeasureThings.this.handleClick(null, (MeasureMarker)object);
                    } else if (object instanceof Waypoint) {
                        MeasureThings.this.handleClick((Waypoint)object, null);
                    }
                }
            }
        };
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("activeGpxObject")) {
                    MeasureThings.this.setActiveGpxObject();
                }
            }
        };
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.setActiveGpxObject();
    }

    public void setActiveGpxObject() {
        this.clearMarker();
        this.points.clear();
        this.widget.clear();
        this.c = 0;
        if (GpsMaster.active.getGpxObject() == null) {
            this.groups = null;
        } else {
            this.groups = GpsMaster.active.getGroups(3);
            if (this.groups.size() == 0) {
                this.msgMeasure.setText("Please select a track, route or segment");
            }
        }
    }

    public UnitConverter getUnitConverter() {
        return this.uc;
    }

    public void setUnitConverter(UnitConverter unitConverter) {
        this.uc = unitConverter;
    }

    public MessageCenter getMessageCenter() {
        return this.msg;
    }

    public void setMessageCenter(MessageCenter messageCenter) {
        this.msg = messageCenter;
        this.msgMeasure = messageCenter.infoOn("select two or more trackpoints.");
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.clickListener;
    }

    public void dispose() {
        this.clearMarker();
        this.points.clear();
        if (this.msg != null) {
            this.msg.infoOff(this.msgMeasure);
        }
    }

    private void clearMarker() {
        for (MeasurePoint measurePoint : this.points) {
            this.mapMarkers.remove(measurePoint.getMarker());
        }
    }

    private void addMarker() {
        for (MeasurePoint measurePoint : this.points) {
            this.mapMarkers.add(measurePoint.getMarker());
        }
    }

    private void handleClick(Waypoint waypoint, MeasureMarker measureMarker) {
        if (this.groups == null || this.groups.size() == 0) {
            return;
        }
        if (measureMarker != null) {
            for (MeasurePoint object : this.points) {
                if (!object.getMarker().equals(measureMarker)) continue;
                this.clearMarker();
                this.points.remove(object);
                this.addMarker();
                break;
            }
        }
        if (waypoint != null) {
            boolean bl = true;
            for (MeasurePoint measurePoint : this.points) {
                if (!measurePoint.getWaypoint().equals(waypoint)) continue;
                this.clearMarker();
                this.points.remove(measurePoint);
                this.addMarker();
                bl = false;
                break;
            }
            if (bl) {
                MeasurePoint measurePoint;
                ++this.c;
                MeasureMarker measureMarker2 = new MeasureMarker(waypoint);
                measureMarker2.setName("M" + Integer.toString(this.c));
                measurePoint = new MeasurePoint(waypoint, measureMarker2);
                try {
                    measurePoint.setIndexesFrom(this.groups);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.clearMarker();
                this.points.add(measurePoint);
                Collections.sort(this.points);
                this.addMarker();
            }
        }
        GpsMaster.active.repaintMap();
        this.doMeasure();
    }

    private void doMeasure() {
        this.widget.clear();
        if (this.points.size() >= 2) {
            double d = 0.0;
            MeasurePoint measurePoint = this.points.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                Waypoint waypoint;
                MeasurePoint measurePoint2 = this.points.get(i);
                int n = measurePoint.getGroupIdx();
                int n2 = measurePoint2.getGroupIdx();
                int n3 = measurePoint.getPointIdx();
                Waypoint waypoint2 = this.groups.get(n2).getWaypoints().get(measurePoint2.getPointIdx());
                WaypointGroup waypointGroup = this.groups.get(n);
                Waypoint waypoint3 = waypoint = waypointGroup.getWaypoints().get(n3);
                Waypoint waypoint4 = null;
                d = 0.0;
                do {
                    waypoint4 = waypointGroup.getWaypoints().get(++n3);
                    d += waypoint4.getDistance(waypoint3);
                    waypoint3 = waypoint4;
                    if (n3 != waypointGroup.getWaypoints().size() - 1 || n >= n2) continue;
                    waypointGroup = this.groups.get(++n);
                    n3 = -1;
                } while (!waypoint4.equals(waypoint2));
                String string = this.uc.dist(d, "%.2f");
                String string2 = this.uc.dist(waypoint.getDistance(waypoint2), "%.2f");
                String string3 = "-";
                String string4 = "-";
                long l = Math.abs(waypoint.getDuration(waypoint2));
                if (l > 0L) {
                    string3 = XTime.getDurationString(l);
                    string4 = this.uc.speed(d / (double)l, "%.1f");
                }
                this.widget.addValues(measurePoint.getMarker(), measurePoint2.getMarker(), string, string2, string3, string4);
                measurePoint = measurePoint2;
            }
        }
    }
}

