/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import com.topografix.gpx._1._1.LinkType;
import eu.fuegenstein.unit.UnitConverter;
import eu.fuegenstein.util.XTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

@Deprecated
public class PropsTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -2702982954383747924L;
    private Timer timer;
    private long lastPropDisplay = 0L;
    private int displayTime = 4;
    private GPXObject gpxObject = null;
    protected List<Integer> extensionIdx = new ArrayList<Integer>();
    private DateFormat sdf = null;
    private UnitConverter uc = null;
    private JTable myTable = null;
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PropsTableModel.this.timer && PropsTableModel.this.lastPropDisplay != 0L && System.currentTimeMillis() - PropsTableModel.this.lastPropDisplay > (long)(PropsTableModel.this.displayTime * 1000)) {
                PropsTableModel.this.updatePropsTable();
                PropsTableModel.this.updateWidth();
                PropsTableModel.this.lastPropDisplay = 0L;
                PropsTableModel.this.timer.stop();
            }
        }
    };
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("activeGpxObject")) {
                PropsTableModel.this.setGpxObject(GpsMaster.active.getGpxObject());
            } else if (string.equals("refreshGpx")) {
                PropsTableModel.this.updatePropsTable();
                PropsTableModel.this.updateWidth();
            } else if (string.equals("activeTrkPt")) {
                Waypoint waypoint = GpsMaster.active.getTrackpoint();
                PropsTableModel.this.setTrackpoint(waypoint, GpsMaster.active.getIndexOf(waypoint));
            }
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (PropsTableModel.this.timer.isRunning()) {
                PropsTableModel.this.timer.stop();
            }
        }
    };

    public PropsTableModel(UnitConverter unitConverter) {
        super(new Object[]{"Name", "Value"}, 0);
        this.setColumnCount(2);
        this.uc = unitConverter;
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        this.timer = new Timer(1000, this.actionListener);
        this.timer.setInitialDelay(1000);
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
    }

    public void setTable(JTable jTable) {
        this.myTable = jTable;
        Enumeration<TableColumn> enumeration = this.myTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(new propTableCellRenderer());
        }
        this.myTable.addMouseListener(this.mouseListener);
    }

    public void setDisplayDuration(int n) {
        this.displayTime = n;
    }

    public int getDisplayDuration() {
        return this.displayTime;
    }

    public synchronized void setGpxObject(GPXObject gPXObject) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.gpxObject = gPXObject;
        this.updatePropsTable();
        this.updateWidth();
    }

    public void setTrackpoint(Waypoint waypoint, int n) {
        this.propsDisplayTrackpoint(waypoint, n);
        this.lastPropDisplay = System.currentTimeMillis();
        this.timer.start();
    }

    private void propsDisplayLink(List<LinkType> list) {
        for (LinkType linkType : list) {
            String string = "link";
            if (linkType.getText() != null) {
                string = linkType.getText();
            }
            this.addRow(new Object[]{string, linkType.getHref()});
        }
    }

    private void propsDisplayExtension(GPXExtension gPXExtension) {
        if (gPXExtension != null) {
            for (GPXExtension gPXExtension2 : gPXExtension.getExtensions()) {
                if (gPXExtension2.getValue() != null) {
                    this.addRow(new Object[]{gPXExtension2.getKey(), gPXExtension2.getValue(), true});
                    this.extensionIdx.add(this.getRowCount() - 1);
                }
                this.propsDisplayExtension(gPXExtension2);
            }
        }
    }

    private void propsDisplayEssentials(GPXObject gPXObject) {
        double d;
        Date date = gPXObject.getStartTime();
        Date date2 = gPXObject.getEndTime();
        if (date != null && date2 != null) {
            String string = "";
            String string2 = "";
            string = this.sdf.format(date);
            string2 = this.sdf.format(date2);
            this.addRow(new Object[]{"start time", string, false});
            this.addRow(new Object[]{"end time", string2, false});
        }
        if (gPXObject.getDuration() != 0L) {
            this.addRow(new Object[]{"duration", XTime.getDurationText(gPXObject.getDuration()), false});
        }
        if ((d = gPXObject.getLengthMeters()) > 0.0) {
            this.addRow(new Object[]{"distance", this.uc.dist(d, "%.2f"), false});
            this.addRow(new Object[]{"max speed", this.uc.speed(gPXObject.getMaxSpeedMps(), "%.1f"), false});
            if (gPXObject.getDuration() > 0L) {
                double d2 = d / (double)gPXObject.getDuration();
                this.addRow(new Object[]{"avg speed", this.uc.speed(d2, "%.1f"), false});
            }
        }
    }

    private void propsDisplayRiseFall(GPXObject gPXObject) {
        double d;
        double d2;
        long l;
        double d3 = gPXObject.getGrossRiseMeters();
        double d4 = gPXObject.getGrossFallMeters();
        this.addRow(new Object[]{"gross rise", this.uc.ele(d3, "%.0f"), false});
        this.addRow(new Object[]{"gross fall", this.uc.ele(d4, "%.0f"), false});
        long l2 = gPXObject.getRiseTime();
        if (l2 > 0L) {
            this.addRow(new Object[]{"rise time", XTime.getDurationText(l2), false});
        }
        if ((l = gPXObject.getFallTime()) > 0L) {
            this.addRow(new Object[]{"fall time", XTime.getDurationText(l), false});
        }
        if (Double.isNaN(d2 = d3 / (double)l2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d2 != 0.0) {
            this.addRow(new Object[]{"avg rise speed", this.uc.vertSpeed(d2, "%.0f"), false});
        }
        if (Double.isNaN(d = d4 / (double)l2) || Double.isInfinite(d)) {
            d = 0.0;
        }
        if (d != 0.0) {
            this.addRow(new Object[]{"avg fall speed", this.uc.vertSpeed(d, "%.0f"), false});
        }
    }

    private void propsDisplayElevation(GPXObject gPXObject) {
        double d;
        double d2;
        double d3;
        double d4 = gPXObject.getEleStartMeters();
        if (d4 > 0.0) {
            this.addRow(new Object[]{"elevation (start)", this.uc.ele(d4, "%.0f"), false});
        }
        if ((d3 = gPXObject.getEleEndMeters()) > 0.0) {
            this.addRow(new Object[]{"elevation (end)", this.uc.ele(d3, "%.0f"), false});
        }
        if ((d2 = gPXObject.getEleMinMeters()) != 2.147483647E9) {
            this.addRow(new Object[]{"min elevation", this.uc.ele(d2, "%.0f"), false});
        }
        if ((d = gPXObject.getEleMaxMeters()) != -2.147483648E9) {
            this.addRow(new Object[]{"max elevation", this.uc.ele(d, "%.0f"), false});
        }
    }

    private void propsDisplayTrackpoint(Waypoint waypoint, int n) {
        if (waypoint != null) {
            this.clear();
            if (n > -1) {
                this.addRow(new Object[]{"trackpoint #", n, false});
            }
            this.addRow(new Object[]{"latitude", waypoint.getLat(), false});
            this.addRow(new Object[]{"longitude", waypoint.getLon(), false});
            this.addRow(new Object[]{"elevation", this.uc.ele(waypoint.getEle(), "%.0f"), false});
            Date date = waypoint.getTime();
            if (date != null) {
                this.addRow(new Object[]{"time", this.sdf.format(date), false});
            }
            if (waypoint.getSat() > 0) {
                this.addRow(new Object[]{"sat", waypoint.getSat(), false});
            }
            if (waypoint.getHdop() > 0.0) {
                this.addRow(new Object[]{"hdop", waypoint.getHdop(), false});
            }
            if (waypoint.getVdop() > 0.0) {
                this.addRow(new Object[]{"vdop", waypoint.getVdop(), false});
            }
            if (waypoint.getPdop() > 0.0) {
                this.addRow(new Object[]{"pdop", waypoint.getPdop(), false});
            }
            if (!waypoint.getName().isEmpty()) {
                this.addRow(new Object[]{"name", waypoint.getName(), true});
            }
            if (!waypoint.getDesc().isEmpty()) {
                this.addRow(new Object[]{"desc", waypoint.getDesc(), true});
            }
            if (!waypoint.getType().isEmpty()) {
                this.addRow(new Object[]{"type", waypoint.getType(), true});
            }
            if (!waypoint.getCmt().isEmpty()) {
                this.addRow(new Object[]{"cmt", waypoint.getCmt(), true});
            }
            if (!waypoint.getSrc().isEmpty()) {
                this.addRow(new Object[]{"src", waypoint.getSrc(), true});
            }
            if (!waypoint.getSym().isEmpty()) {
                this.addRow(new Object[]{"sym", waypoint.getSym(), true});
            }
            if (!waypoint.getFix().isEmpty()) {
                this.addRow(new Object[]{"fix", waypoint.getFix(), true});
            }
            this.propsDisplayLink(waypoint.getLink());
            if (waypoint.getMagvar() > 0.0) {
                this.addRow(new Object[]{"magvar", waypoint.getMagvar(), false});
            }
            if (waypoint.getGeoidheight() > 0.0) {
                this.addRow(new Object[]{"geoidheight", waypoint.getGeoidheight(), false});
            }
            if (waypoint.getAgeofdgpsdata() > 0.0) {
                this.addRow(new Object[]{"ageofdgpsdata", waypoint.getAgeofdgpsdata(), false});
            }
            if (waypoint.getDgpsid() > 0) {
                this.addRow(new Object[]{"dgpsid", waypoint.getDgpsid(), false});
            }
            this.propsDisplayExtension(waypoint.getExtension());
            this.lastPropDisplay = System.currentTimeMillis();
        }
    }

    private void propsDisplayWaypointGrp(GPXObject gPXObject) {
        WaypointGroup waypointGroup = (WaypointGroup)gPXObject;
        this.addRow(new Object[]{"name", waypointGroup.getName(), true});
        this.addRow(new Object[]{"# of pts", waypointGroup.getWaypoints().size(), false});
    }

    private void propsDisplayRoute(GPXObject gPXObject) {
        Route route = (Route)gPXObject;
        this.addRow(new Object[]{"name", route.getName(), true});
        this.addRow(new Object[]{"# of pts", route.getNumPts(), false});
    }

    private void propsDisplayTrack(GPXObject gPXObject) {
        Track track = (Track)gPXObject;
        if (track.getName() != null) {
            this.addRow(new Object[]{"track name", track.getName(), true});
        }
        if (track.getDesc() != null) {
            this.addRow(new Object[]{"desc", track.getDesc(), true});
        }
        if (track.getType() != null) {
            this.addRow(new Object[]{"type", track.getType(), true});
        }
        if (track.getTracksegs().size() > 0) {
            this.addRow(new Object[]{"segments", track.getTracksegs().size(), false});
        }
        if (track.getNumPts() > 0L) {
            this.addRow(new Object[]{"# of pts", track.getNumPts(), false});
        }
        if (track.getNumber() != 0) {
            this.addRow(new Object[]{"track number", track.getNumber(), true});
        }
        this.propsDisplayLink(track.getLink());
    }

    private void propsDisplayGpxFile(GPXObject gPXObject) {
        GPXFile gPXFile = (GPXFile)gPXObject;
        this.addRow(new Object[]{"GPX name", gPXFile.getMetadata().getName(), true});
        if (gPXFile.getMetadata().getDesc() != null) {
            this.addRow(new Object[]{"GPX desc", gPXFile.getMetadata().getDesc(), true});
        }
        if (!gPXFile.getCreator().isEmpty()) {
            this.addRow(new Object[]{"creator", gPXFile.getCreator()});
        }
        String string = "";
        if (gPXFile.getMetadata().getTime() != null) {
            Date date = gPXFile.getMetadata().getTime();
            string = this.sdf.format(date);
        }
        this.addRow(new Object[]{"GPX time", string, false});
        if (gPXFile.getRoutes().size() > 0) {
            this.addRow(new Object[]{"# of routes", gPXFile.getRoutes().size(), false});
        }
        if (gPXFile.getTracks().size() > 0) {
            this.addRow(new Object[]{"# of tracks", gPXFile.getTracks().size(), false});
        }
        if (gPXFile.getNumWayPts() > 0L) {
            this.addRow(new Object[]{"# of waypoints", gPXFile.getNumWayPts(), false});
        }
        if (gPXFile.getNumTrackPts() > 0L) {
            this.addRow(new Object[]{"# of trackpoints", gPXFile.getNumTrackPts(), false});
        }
    }

    private void updatePropsTable() {
        this.clear();
        if (this.gpxObject != null) {
            if (this.gpxObject.isGPXFile()) {
                this.propsDisplayGpxFile(this.gpxObject);
                this.propsDisplayEssentials(this.gpxObject);
                this.propsDisplayElevation(this.gpxObject);
                this.propsDisplayRiseFall(this.gpxObject);
                this.propsDisplayExtension(this.gpxObject.getExtension());
            } else if (this.gpxObject.isTrack()) {
                this.propsDisplayTrack(this.gpxObject);
                this.propsDisplayEssentials(this.gpxObject);
                this.propsDisplayElevation(this.gpxObject);
                this.propsDisplayRiseFall(this.gpxObject);
                this.propsDisplayExtension(this.gpxObject.getExtension());
            } else if (this.gpxObject.isRoute()) {
                this.propsDisplayRoute(this.gpxObject);
                this.propsDisplayEssentials(this.gpxObject);
                this.propsDisplayElevation(this.gpxObject);
            } else if (this.gpxObject.isTrackseg()) {
                this.propsDisplayWaypointGrp(this.gpxObject);
                this.propsDisplayEssentials(this.gpxObject);
                this.propsDisplayElevation(this.gpxObject);
                this.propsDisplayRiseFall(this.gpxObject);
                this.propsDisplayExtension(this.gpxObject.getExtension());
            } else if (this.gpxObject.isWaypointGroup()) {
                this.propsDisplayWaypointGrp(this.gpxObject);
                this.propsDisplayElevation(this.gpxObject);
                this.propsDisplayExtension(this.gpxObject.getExtension());
            }
        }
    }

    private void updateWidth() {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.myTable.getRowCount(); ++n2) {
            TableCellRenderer tableCellRenderer = this.myTable.getCellRenderer(n2, 0);
            object = this.myTable.prepareRenderer(tableCellRenderer, n2, 0);
            n3 = Math.max(((Component)object).getPreferredSize().width, n3);
        }
        n3 += this.myTable.getIntercellSpacing().width;
        this.myTable.getColumn("Name").setMaxWidth(n3 += 10);
        this.myTable.getColumn("Name").setMinWidth(n3);
        this.myTable.getColumn("Name").setPreferredWidth(n3);
        n2 = 0;
        for (n = 0; n < this.myTable.getRowCount(); ++n) {
            object = this.myTable.getCellRenderer(n, 1);
            Component component = this.myTable.prepareRenderer((TableCellRenderer)object, n, 1);
            n2 = Math.max(component.getPreferredSize().width, n2);
        }
        n = (n2 += this.myTable.getIntercellSpacing().width) + n3;
        if (this.myTable.getParent() instanceof JScrollPane) {
            object = (JScrollPane)this.myTable.getParent();
            if (((JScrollPane)object).getVerticalScrollBar().isVisible()) {
                n += ((JScrollPane)object).getVerticalScrollBar().getWidth();
            }
            if (n > ((JComponent)object).getWidth()) {
                this.myTable.setAutoResizeMode(0);
                n2 += 10;
            } else {
                this.myTable.setAutoResizeMode(3);
                n2 = ((JComponent)object).getWidth() + n3;
            }
            this.myTable.getColumn("Value").setMinWidth(n2);
            this.myTable.getColumn("Value").setPreferredWidth(n2);
        }
    }

    public void clear() {
        this.setRowCount(0);
        this.extensionIdx.clear();
    }

    class propTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 6876231432766928405L;

        propTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(null);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setText(String.valueOf(object));
            if (PropsTableModel.this.extensionIdx.contains(n)) {
                this.setForeground(Color.BLUE);
            } else {
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }
}

