/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.Waypoint;

public class TrackSlider
extends JSlider {
    private static final long serialVersionUID = 332307178698570815L;
    private int myValue = 0;
    private PropertyChangeListener changeListener = null;

    public TrackSlider() {
        this.init();
    }

    private void init() {
        this.setOrientation(0);
        this.setMinimum(0);
        this.setMaximum(0);
        this.setPaintLabels(false);
        this.setPaintTicks(false);
        this.setAlignmentX(0.0f);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = TrackSlider.this.getValue();
                if (n > -1) {
                    GpsMaster.active.setTrackpoint(n);
                }
            }
        });
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                int n2;
                Waypoint waypoint;
                if (propertyChangeEvent.getPropertyName().equals("activeGpxObject")) {
                    TrackSlider.this.setValue(-1);
                    if (GpsMaster.active.getGpxObject() == null) {
                        TrackSlider.this.setEnabled(false);
                    } else {
                        TrackSlider.this.setMaximum(GpsMaster.active.getNumWaypoints() - 1);
                        TrackSlider.this.setEnabled(true);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("activeTrkPt") && (waypoint = GpsMaster.active.getTrackpoint()) != null && Math.abs((n2 = GpsMaster.active.getTotalIndexOf(waypoint)) - (n = TrackSlider.this.getValue())) > 5) {
                    TrackSlider.this.setValue(n2);
                }
            }
        };
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
    }

    @Override
    public void setValue(int n) {
        this.myValue = n;
        super.setValue(n);
    }

    @Override
    public int getValue() {
        return this.myValue;
    }
}

