/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.unit.UnitConverter;
import org.gpsmaster.chart.ChartXAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.NumberAxis;

public class DistanceAxis
extends ChartXAxis {
    private double distance = 0.0;
    private Waypoint prev = null;

    public DistanceAxis(UnitConverter unitConverter) {
        super(unitConverter);
        this.title = "Distance";
        this.iconFile = "axis_distance.png";
        this.valueAxis = new NumberAxis();
        this.valueAxis.setLabel(unitConverter.getTargetSet().getDistanceUnit().getSymbol());
        super.setDefaults();
        this.enableCaching();
    }

    @Override
    public double getValue(Waypoint waypoint) {
        if (this.prev != null) {
            this.distance += waypoint.getDistance(this.prev);
        }
        this.prev = waypoint;
        double d = this.uc.dist(this.distance);
        this.cache(waypoint, d);
        return d;
    }

    @Override
    public void reset() {
        this.distance = 0.0;
        this.prev = null;
    }
}

