/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.unit.UnitConverter;
import java.util.Locale;
import java.util.TimeZone;
import org.gpsmaster.chart.ChartXAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.DateAxis;

public class DurationAxis
extends ChartXAxis {
    private Waypoint first = null;

    public DurationAxis(UnitConverter unitConverter) {
        super(unitConverter);
        this.title = "Duration";
        this.iconFile = "axis_duration.png";
        this.valueAxis = new DateAxis(this.title, TimeZone.getTimeZone("UTC"), Locale.getDefault());
        this.valueAxis.setLabel("hrs");
        super.setDefaults();
    }

    @Override
    public double getValue(Waypoint waypoint) {
        long l = 0L;
        if (waypoint != null && waypoint.getTime() != null) {
            if (this.first == null) {
                this.first = waypoint;
            }
            l = waypoint.getTime().getTime() - this.first.getTime().getTime();
        }
        return l;
    }

    @Override
    public void reset() {
        this.first = null;
    }
}

