/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.cleaning;

import eu.fuegenstein.parameter.CommonParameter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.gpsmaster.GenericAlgorithm;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.dialogs.CleaningStats;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.marker.RemoveMarker;
import org.gpsmaster.undo.UndoWaypointGroup;

public abstract class CleaningAlgorithm
extends GenericAlgorithm {
    private JPanel algorithmPanel = null;
    private CleaningStats statPanel = null;
    protected Hashtable<WaypointGroup, List<Waypoint>> allGroups = new Hashtable();
    protected List<Marker> markerList = null;

    @Override
    public void setWaypointGroups(List<WaypointGroup> list) {
        this.allGroups.clear();
        for (WaypointGroup waypointGroup : list) {
            ArrayList arrayList = new ArrayList();
            this.allGroups.put(waypointGroup, arrayList);
        }
    }

    public void setMarkerList(List<Marker> list) {
        this.markerList = list;
    }

    @Override
    public void apply() {
        if (this.getNumDelete() == 0) {
            this.applyAll();
        }
        Enumeration<WaypointGroup> enumeration = this.allGroups.keys();
        while (enumeration.hasMoreElements()) {
            WaypointGroup waypointGroup = enumeration.nextElement();
            UndoWaypointGroup undoWaypointGroup = new UndoWaypointGroup("Cleaning " + this.getName());
            undoWaypointGroup.setOldGroup(waypointGroup);
            List<Waypoint> list = this.allGroups.get(waypointGroup);
            for (Waypoint waypoint : list) {
                waypointGroup.getWaypoints().remove(waypoint);
            }
            undoWaypointGroup.setNewGroup(waypointGroup);
            GpsMaster.active.addUndoOperation(undoWaypointGroup);
            waypointGroup.updateAllProperties();
        }
        this.clear();
    }

    public void preview() {
        this.clear();
        this.applyAll();
        this.populateMarkerList();
        if (this.statPanel != null) {
            int n = 0;
            for (WaypointGroup waypointGroup : this.allGroups.keySet()) {
                n += waypointGroup.getNumPts();
            }
            this.statPanel.setStats(this.getAffected(), n);
        }
    }

    public long getAffected() {
        int n = this.getNumDelete();
        if (n == 0) {
            this.applyAll();
            n = this.getNumDelete();
        }
        return n;
    }

    @Override
    public List<CommonParameter> getParameters() {
        return this.params;
    }

    public JPanel getPanel(Color color) {
        if (this.algorithmPanel == null) {
            this.algorithmPanel = new JPanel();
            this.makePanel(color);
        }
        return this.algorithmPanel;
    }

    public JPanel getPanel() {
        if (this.algorithmPanel != null) {
            return this.algorithmPanel;
        }
        return this.getPanel(Color.WHITE);
    }

    @Override
    public void clear() {
        super.clear();
        this.clearMarkerList();
        for (List<Waypoint> list : this.allGroups.values()) {
            list.clear();
        }
        if (this.statPanel != null) {
            this.statPanel.clear();
        }
    }

    protected abstract void applyAlgorithm(WaypointGroup var1, List<Waypoint> var2);

    protected void populateMarkerList() {
        if (this.markerList != null) {
            for (List<Waypoint> list : this.allGroups.values()) {
                for (Waypoint waypoint : list) {
                    RemoveMarker removeMarker = new RemoveMarker(waypoint);
                    removeMarker.setMarkerPosition(5);
                    this.markerList.add(removeMarker);
                }
            }
        }
    }

    protected void clearMarkerList() {
        if (this.markerList != null) {
            ArrayList<Marker> arrayList = new ArrayList<Marker>();
            for (Marker marker : this.markerList) {
                if (!(marker instanceof RemoveMarker)) continue;
                arrayList.add(marker);
            }
            for (Marker marker : arrayList) {
                this.markerList.remove(marker);
            }
        }
    }

    protected void makePanel(Color color) {
        this.algorithmPanel.setLayout(new BoxLayout(this.algorithmPanel, 1));
        this.algorithmPanel.setBackground(color);
        Font font = new Font(this.algorithmPanel.getFont().getFamily(), 1, this.algorithmPanel.getFont().getSize() + 2);
        JLabel jLabel = new JLabel();
        jLabel.setFont(font);
        jLabel.setText(this.getName());
        jLabel.setAlignmentX(0.0f);
        jLabel.setBackground(color);
        this.algorithmPanel.add(jLabel);
        if (!this.getDescription().isEmpty()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setFont(this.algorithmPanel.getFont());
            jTextArea.setPreferredSize(new Dimension(220, 120));
            jTextArea.setText(this.getDescription());
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setAlignmentX(0.0f);
            jTextArea.setBackground(color);
            this.algorithmPanel.add(jTextArea);
        }
        for (CommonParameter commonParameter : this.params) {
            JPanel jPanel = commonParameter.getGuiComponent(new Dimension(40, 20));
            jPanel.setAlignmentX(0.0f);
            this.algorithmPanel.add(jPanel);
        }
        this.statPanel = new CleaningStats();
        this.statPanel.setBackground(color);
        this.statPanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.statPanel.setAlignmentX(0.0f);
        this.algorithmPanel.add(this.statPanel);
    }

    private void applyAll() {
        for (WaypointGroup waypointGroup : this.allGroups.keySet()) {
            List<Waypoint> list = this.allGroups.get(waypointGroup);
            this.applyAlgorithm(waypointGroup, list);
        }
    }

    private int getNumDelete() {
        int n = 0;
        for (List<Waypoint> list : this.allGroups.values()) {
            n += list.size();
        }
        return n;
    }
}

