/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.cleaning;

import eu.fuegenstein.parameter.DoubleParameter;
import eu.fuegenstein.parameter.IntegerParameter;
import java.util.List;
import org.gpsmaster.cleaning.CleaningAlgorithm;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class CloudBuster
extends CleaningAlgorithm {
    private DoubleParameter radius = new DoubleParameter(2.0);
    private IntegerParameter threshold = new IntegerParameter(5);
    private IntegerParameter checkNeighbours = new IntegerParameter(25);

    public CloudBuster() {
        this.setName("CloudBuster");
        this.setDescription("Detect and remove clouds of points");
        this.radius.setName("Radius");
        this.radius.setDescription("Radius to check");
        this.params.add(this.radius);
        this.threshold.setName("Threshold");
        this.threshold.setDescription("# of close points defining a cloud");
        this.params.add(this.threshold);
        this.checkNeighbours.setName("CheckNeighbours");
        this.checkNeighbours.setDescription("neighbours to check");
        this.params.add(this.checkNeighbours);
    }

    @Override
    protected void applyAlgorithm(WaypointGroup waypointGroup, List<Waypoint> list) {
        List<Waypoint> list2 = waypointGroup.getWaypoints();
        for (int i = 0; i < list2.size(); ++i) {
            Waypoint waypoint = list2.get(i);
            int n = 0;
            for (int j = 0; j < this.checkNeighbours.getValue() && i + j + 1 < list2.size(); ++j) {
                Waypoint waypoint2 = list2.get(i + j + 1);
                if (!(waypoint.getDistance(waypoint2) < this.radius.getValue())) continue;
                ++n;
                if (list.contains(waypoint2)) continue;
                list.add(waypoint2);
            }
            if (n <= this.threshold.getValue()) continue;
        }
    }
}

