/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import java.net.URI;
import javax.swing.JOptionPane;

public abstract class BrowserLauncher {
    private static boolean _initialised = false;
    private static String[] _browserCommand = null;
    private static boolean _urlNeedsQuotes = false;

    private static void init() {
        String[] stringArray;
        _browserCommand = null;
        if (BrowserLauncher.commandExists("which")) {
            stringArray = new String[]{"firefox", "iceweasel", "konqueror", "opera", "epiphany", "mozilla", "chromium", "midori", "safari", "lynx"};
            String string = null;
            for (String string2 : stringArray) {
                if (!BrowserLauncher.commandExists(string2)) continue;
                string = string2;
                break;
            }
            if (string != null) {
                _browserCommand = new String[]{string, null};
            }
        }
        if (_browserCommand == null) {
            boolean bl;
            stringArray = System.getProperty("os.name").toLowerCase();
            boolean bl2 = bl = stringArray.indexOf("mac os") >= 0 || stringArray.indexOf("darwin") >= 0;
            if (bl) {
                _browserCommand = new String[]{"open", null};
            } else {
                _browserCommand = new String[]{"cmd.exe", "/C", "start", "\"\"", null};
                _urlNeedsQuotes = true;
            }
        }
        _initialised = true;
    }

    private static boolean commandExists(String string) {
        try {
            String[] stringArray = new String[]{"which", string};
            if (Runtime.getRuntime().exec(stringArray).waitFor() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void launchBrowser(String string) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            clazz.getDeclaredMethod("browse", URI.class).invoke(clazz.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(string));
        }
        catch (Exception exception) {
            if (!_initialised) {
                BrowserLauncher.init();
            }
            if (_browserCommand == null) {
                JOptionPane.showMessageDialog(null, "Cannot show url: " + string);
            }
            try {
                String string2 = string;
                if (_urlNeedsQuotes) {
                    string2 = "\"" + string2 + "\"";
                }
                BrowserLauncher._browserCommand[BrowserLauncher._browserCommand.length - 1] = string2;
                Runtime.getRuntime().exec(_browserCommand);
            }
            catch (Exception exception2) {
                JOptionPane.showMessageDialog(null, "Failed to show url: " + string);
            }
        }
    }
}

