/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import eu.fuegenstein.swing.ExtendedTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.gpsmaster.db.DbLayer;
import org.gpsmaster.db.GpsRecord;
import org.gpsmaster.dialogs.DbTableModel;
import org.gpsmaster.dialogs.DistanceRenderer;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.IItemSource;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;

public class DBDialog
extends GenericDialog
implements Runnable,
IItemSource {
    private static final long serialVersionUID = -1422533436670399564L;
    private final byte COL_COLOR = 0;
    private final byte COL_STARTDATE = 1;
    private final byte COL_DISTANCE = (byte)3;
    private final byte COL_DURATION = (byte)4;
    private DbLayer dbLayer = null;
    private FileHub fileHub = null;
    private MessagePanel infoPanel = null;
    private ExtendedTable dbTable = null;
    private DbTableModel dbModel = null;
    private JButton btnLoad = null;
    private JButton btnImport = null;
    private JButton btnExport = null;
    private JButton btnDelete = null;
    private JButton btnRefresh = null;
    private JButton btnCancel = null;
    private JButton btnClose = null;
    private TransferableItem currentItem = null;
    private final List<TransferableItem> items = Collections.synchronizedList(new ArrayList());
    private InputStream dbInputStream = null;
    private PropertyChangeListener fileHubListener = null;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("refreshDb")) {
                DBDialog.this.refreshTable();
            }
        }
    };

    public DBDialog(JFrame jFrame, MessageCenter messageCenter, DbLayer dbLayer, FileHub fileHub) {
        super(jFrame, messageCenter);
        this.dbLayer = dbLayer;
        this.fileHub = fileHub;
    }

    public DbLayer getStorage() {
        return this.dbLayer;
    }

    public void setStorage(DbLayer dbLayer) {
        this.dbLayer = dbLayer;
    }

    public PropertyChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public String getName() {
        return "GPS Database";
    }

    @Override
    public DataType getDataType() {
        return DataType.STREAM;
    }

    @Override
    public boolean doShowProgressText() {
        return true;
    }

    @Override
    public List<TransferableItem> getItems() {
        return this.items;
    }

    @Override
    public GPXFile getGpxFile(TransferableItem transferableItem) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void open(TransferableItem transferableItem) {
        this.currentItem = transferableItem;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        GpsRecord gpsRecord = (GpsRecord)this.currentItem;
        this.dbInputStream = this.dbLayer.getGpsData(gpsRecord.getId());
        if (gpsRecord.isCompressed()) {
            ZipInputStream zipInputStream = new ZipInputStream(this.dbInputStream);
            zipInputStream.getNextEntry();
        }
        return this.dbInputStream;
    }

    @Override
    public void close() throws Exception {
        if (this.dbInputStream != null) {
            this.dbInputStream.close();
        }
        this.currentItem = null;
    }

    private void setup() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.fileHubListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("transferItemStateChanged")) {
                    if (string.equals("transferStarted")) {
                        DBDialog.this.btnCancel.setEnabled(true);
                    } else if (string.equals("transferFinished")) {
                        DBDialog.this.btnCancel.setEnabled(false);
                    }
                }
            }
        };
        this.fileHub.addChangeListener(this.fileHubListener);
        this.getContentPane().setLayout(new BorderLayout());
        this.setIcon("/org/gpsmaster/icons/downloadbar/", "database.png");
        this.dbModel = new DbTableModel(this.dbLayer);
        this.dbTable = new ExtendedTable(this.dbModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                if (n > -1) {
                    int n2 = this.convertRowIndexToModel(n);
                    int n3 = this.columnAtPoint(point);
                    if (n3 == 5 && n2 > -1) {
                        string = DBDialog.this.dbModel.get(n2).getActivity();
                    }
                }
                return string;
            }
        };
        this.dbTable.setColumnWidthPadding(10);
        this.dbTable.setGridColor(Color.LIGHT_GRAY);
        this.dbTable.setSelectionMode(2);
        this.dbTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                DBDialog.this.selectionButtonsEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
        this.dbTable.setAutoCreateRowSorter(true);
        this.dbTable.getColumnModel().getColumn(0).setMaxWidth(16);
        this.dbTable.minimizeColumnWidth(1, 0);
        this.dbTable.minimizeColumnWidth(3, 1);
        this.dbTable.minimizeColumnWidth(4, 1);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        DistanceRenderer distanceRenderer = new DistanceRenderer(this.uc);
        this.dbTable.getColumnModel().getColumn(3).setCellRenderer(distanceRenderer);
        this.dbTable.getColumnModel().getColumn(4).setCellRenderer(defaultTableCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.dbTable);
        this.dbTable.setFillsViewportHeight(true);
        this.btnLoad = new JButton();
        this.btnLoad.setText("Load");
        this.btnLoad.setToolTipText("Load selected entries from database");
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDialog.this.load();
            }
        });
        jPanel2.add(this.btnLoad);
        this.btnImport = new JButton();
        this.btnImport.setText("Import");
        this.btnImport.setToolTipText("import files into database");
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDialog.this.importFiles();
            }
        });
        this.btnImport.setEnabled(true);
        this.btnExport = new JButton();
        this.btnExport.setText("Export");
        this.btnExport.setToolTipText("Export to file");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDialog.this.export();
            }
        });
        this.btnDelete = new JButton();
        this.btnDelete.setText("Delete");
        this.btnDelete.setToolTipText("Delete selected entries from database");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(DBDialog.this.parentFrame, "Delete selected entries?", "Title", 2);
                if (n == 0) {
                    DBDialog.this.delete();
                }
            }
        });
        jPanel2.add(this.btnDelete);
        this.btnRefresh = new JButton();
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setToolTipText("Refresh table");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDialog.this.refreshTable();
            }
        });
        jPanel2.add(this.btnRefresh);
        this.selectionButtonsEnabled(false);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDialog.this.fileHub.cancel();
            }
        });
        this.btnCancel.setEnabled(false);
        jPanel2.add(this.btnCancel);
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDialog.this.dispose();
            }
        });
        jPanel2.add(this.btnClose);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        this.setSize(800, 600);
        this.setCenterLocation();
        this.setVisible(true);
    }

    @Override
    public String getTitle() {
        return "GPS Database";
    }

    @Override
    public void begin() {
        this.setup();
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.refreshTable();
    }

    private synchronized void refreshTable() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                DBDialog.this.selectionButtonsEnabled(false);
                DBDialog.this.btnRefresh.setEnabled(false);
                try {
                    DBDialog.this.busyOn();
                    DBDialog.this.disableAllButtons();
                    DBDialog.this.dbModel.refresh();
                    DBDialog.this.dbTable.minimizeColumnWidth(1, 2);
                    DBDialog.this.dbTable.minimizeColumnWidth(2, 2);
                    DBDialog.this.dbTable.minimizeColumnWidth(3, 0);
                    DBDialog.this.dbTable.minimizeColumnWidth(4, 0);
                    DBDialog.this.dbTable.minimizeColumnWidth(5, 2);
                }
                catch (Exception exception) {
                    DBDialog.this.msg.error(exception);
                }
                return null;
            }

            @Override
            protected void done() {
                DBDialog.this.btnRefresh.setEnabled(true);
                DBDialog.this.busyOff();
            }
        };
        swingWorker.execute();
    }

    private void load() {
        for (int n : this.dbTable.getSelectedRows()) {
            int n2 = this.dbTable.convertRowIndexToModel(n);
            this.items.add(this.dbModel.get(n2));
        }
        this.fileHub.run();
    }

    private void delete() {
        this.infoPanel = this.msg.infoOn("Deleting ...", new Cursor(3));
        for (int n : this.dbTable.getSelectedRows()) {
            try {
                int n2 = this.dbTable.convertRowIndexToModel(n);
                this.dbLayer.deleteGpsRecord(this.dbModel.get(n2).getId());
            }
            catch (Exception exception) {
                this.msg.error(exception);
                exception.printStackTrace();
            }
        }
        this.refreshTable();
        this.msg.infoOff(this.infoPanel);
    }

    private void disableAllButtons() {
        this.btnLoad.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnRefresh.setEnabled(false);
    }

    private void enableAllButtons() {
        this.btnLoad.setEnabled(true);
        this.btnImport.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }

    private void selectionButtonsEnabled(boolean bl) {
        this.btnLoad.setEnabled(bl);
        this.btnDelete.setEnabled(bl);
        this.btnExport.setEnabled(bl);
    }

    private void importFiles() {
    }

    private void export() {
    }
}

