/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.parameter.CommonParameter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.gpsmaster.GenericAlgorithm;

public class GenericAlgorithmPanel
extends JPanel {
    protected JLabel nameLabel = new JLabel();
    protected JTextArea descLabel = new JTextArea();
    protected GenericAlgorithm algo = null;
    private static final long serialVersionUID = 8930736599707243527L;

    public GenericAlgorithmPanel(GenericAlgorithm genericAlgorithm) {
        this.algo = genericAlgorithm;
        this.setLayout(new BoxLayout(this, 1));
        Font font = new Font(this.getFont().getFamily(), 1, this.getFont().getSize() + 2);
        this.nameLabel.setFont(font);
        this.nameLabel.setText(this.algo.getName());
        this.nameLabel.setAlignmentX(0.0f);
        this.add(this.nameLabel);
        if (!this.algo.getDescription().isEmpty()) {
            this.descLabel.setFont(this.getFont());
            this.descLabel.setPreferredSize(new Dimension(220, 120));
            this.descLabel.setText(this.algo.getDescription());
            this.descLabel.setEditable(false);
            this.descLabel.setLineWrap(true);
            this.descLabel.setWrapStyleWord(true);
            this.descLabel.setAlignmentX(0.0f);
            this.add(this.descLabel);
        }
        for (CommonParameter commonParameter : this.algo.getParameters()) {
            JPanel jPanel = commonParameter.getGuiComponent(new Dimension(40, 20));
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.nameLabel != null) {
            this.nameLabel.setBackground(color);
        }
        if (this.descLabel != null) {
            this.descLabel.setBackground(color);
        }
    }
}

