/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.swing.ExtendedTable;
import eu.fuegenstein.unit.UnitConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.dialogs.GpxExtensionTreeRenderer;
import org.gpsmaster.dialogs.GpxPropertiesTableModel;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Waypoint;

public class GpxPropertiesPanel
extends JPanel {
    private static final long serialVersionUID = -7442048764647078316L;
    private GPXObject currentGpx = null;
    private JTree extensionsTree = null;
    private GpxExtensionTreeRenderer treeRenderer = null;
    private GpxPropertiesTableModel propsTableModel = null;
    private JTable propsTable = null;
    private UnitConverter uc = null;
    private Timer timer;
    private long lastPropDisplay = 0L;
    private int displayTime = 4;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("activeGpxObject") || string.equals("refreshGpx")) {
                GpxPropertiesPanel.this.setActiveGpxObject(GpsMaster.active.getGpxObject());
            } else if (string.equals("activeTrkPt")) {
                Waypoint waypoint = GpsMaster.active.getTrackpoint();
                GpxPropertiesPanel.this.setTrackpoint(waypoint, GpsMaster.active.getIndexOf(waypoint));
            } else if (string.equals("activeWpt")) {
                Waypoint waypoint = GpsMaster.active.getWaypoint();
                GpxPropertiesPanel.this.setWaypoint(waypoint);
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GpxPropertiesPanel.this.timer && GpxPropertiesPanel.this.lastPropDisplay != 0L && System.currentTimeMillis() - GpxPropertiesPanel.this.lastPropDisplay > (long)(GpxPropertiesPanel.this.displayTime * 1000)) {
                GpxPropertiesPanel.this.propsTableModel.setGpxObject(GpxPropertiesPanel.this.currentGpx);
                GpxPropertiesPanel.this.updateExtensionTree(GpxPropertiesPanel.this.currentGpx.getExtension());
                GpxPropertiesPanel.this.updateWidth();
                GpxPropertiesPanel.this.lastPropDisplay = 0L;
                GpxPropertiesPanel.this.timer.stop();
            }
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (GpxPropertiesPanel.this.timer.isRunning()) {
                GpxPropertiesPanel.this.timer.stop();
            }
        }
    };

    public GpxPropertiesPanel(UnitConverter unitConverter) {
        this.uc = unitConverter;
        this.setup();
        this.timer = new Timer(1000, this.actionListener);
        this.timer.setInitialDelay(1000);
    }

    public void setDisplayDuration(int n) {
        this.displayTime = n;
    }

    public int getDisplayDuration() {
        return this.displayTime;
    }

    private void setActiveGpxObject(GPXObject gPXObject) {
        this.currentGpx = gPXObject;
        this.propsTableModel.setGpxObject(this.currentGpx);
        this.updateWidth();
        if (this.currentGpx != null) {
            this.updateExtensionTree(this.currentGpx.getExtension());
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private void setTrackpoint(Waypoint waypoint, int n) {
        if (waypoint != null) {
            this.propsTableModel.setTrackpoint(waypoint, n);
            this.updateExtensionTree(null != waypoint ? waypoint.getExtension() : null);
            this.updateWidth();
            this.lastPropDisplay = System.currentTimeMillis();
            this.timer.start();
        }
    }

    private void setWaypoint(Waypoint waypoint) {
        if (waypoint != null) {
            this.propsTableModel.setTrackpoint(waypoint, -1);
            this.updateExtensionTree(null != waypoint ? waypoint.getExtension() : null);
            this.updateWidth();
        }
    }

    private void updateExtensionTree(GPXExtension gPXExtension) {
        if (this.extensionsTree != null) {
            this.remove(this.extensionsTree);
            this.extensionsTree = null;
        }
        if (gPXExtension != null && gPXExtension.getChildCount() > 0) {
            this.extensionsTree = new JTree(gPXExtension);
            this.extensionsTree.setRootVisible(false);
            this.extensionsTree.setEditable(false);
            this.extensionsTree.getSelectionModel().setSelectionMode(1);
            this.extensionsTree.setShowsRootHandles(true);
            this.extensionsTree.setCellRenderer(this.treeRenderer);
            this.extensionsTree.putClientProperty("JTree.lineStyle", "None");
            this.extensionsTree.setBackground(Color.white);
            this.extensionsTree.setToggleClickCount(0);
            this.extensionsTree.setAlignmentX(0.0f);
            this.extensionsTree.setAlignmentY(0.0f);
            this.add(this.extensionsTree);
            for (int i = 0; i < this.extensionsTree.getRowCount(); ++i) {
                this.extensionsTree.expandRow(i);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void setup() {
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(Color.white);
        this.propsTableModel = new GpxPropertiesTableModel(this.uc);
        this.propsTable = new ExtendedTable(this.propsTableModel);
        this.propsTable.setAlignmentX(0.0f);
        this.propsTable.setAutoResizeMode(0);
        this.add(this.propsTable);
        this.treeRenderer = new GpxExtensionTreeRenderer();
    }

    private void updateWidth() {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.propsTable.getRowCount(); ++n2) {
            TableCellRenderer tableCellRenderer = this.propsTable.getCellRenderer(n2, 0);
            object = this.propsTable.prepareRenderer(tableCellRenderer, n2, 0);
            n3 = Math.max(((Component)object).getPreferredSize().width, n3);
        }
        n3 += this.propsTable.getIntercellSpacing().width;
        this.propsTable.getColumn("Name").setMaxWidth(n3 += 10);
        this.propsTable.getColumn("Name").setMinWidth(n3);
        this.propsTable.getColumn("Name").setPreferredWidth(n3);
        n2 = 0;
        for (n = 0; n < this.propsTable.getRowCount(); ++n) {
            object = this.propsTable.getCellRenderer(n, 1);
            Component component = this.propsTable.prepareRenderer((TableCellRenderer)object, n, 1);
            n2 = Math.max(component.getPreferredSize().width, n2);
        }
        n = (n2 += this.propsTable.getIntercellSpacing().width) + n3;
        if (this.propsTable.getParent() instanceof JScrollPane) {
            object = (JScrollPane)this.propsTable.getParent();
            if (((JScrollPane)object).getVerticalScrollBar().isVisible()) {
                n += ((JScrollPane)object).getVerticalScrollBar().getWidth();
            }
            if (n > ((JComponent)object).getWidth()) {
                this.propsTable.setAutoResizeMode(0);
                n2 += 10;
            } else {
                this.propsTable.setAutoResizeMode(3);
                n2 = ((JComponent)object).getWidth() + n3;
            }
            this.propsTable.getColumn("Value").setMinWidth(n2);
            this.propsTable.getColumn("Value").setPreferredWidth(n2);
        }
    }
}

