/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.osm.Nominatim;
import eu.fuegenstein.osm.NominatimPlace;
import eu.fuegenstein.osm.NominatimResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.dialogs.NameResultModel;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.PinMarker;
import org.gpsmaster.marker.WaypointMarker;

public class NameSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1503013835813804411L;
    private JPanel entryPanel = null;
    private JTextField textField = null;
    private ActionListener actionListener = null;
    private JButton wptButton = null;
    private JButton searchButton = null;
    private JButton rptButton = null;
    private ImageIcon searchIcon = null;
    private ImageIcon searchMoreIcon = null;
    private final String tooltip = "Search place by name";
    private final String moreTooltip = "get more results";
    private JScrollPane scrollPane = null;
    private JTable resultTable = null;
    private NameResultModel resultModel = null;
    private JLabel attributionLabel = null;
    private PinMarker pin = null;
    private Nominatim nominatim = new Nominatim();
    private NominatimResult result = null;
    private MessageCenter msg = null;
    private boolean isBusy = false;
    private boolean addRoutePoints = false;
    private final int minLength = 3;
    private final int sizeRows = 5;
    private Dimension emptySize = new Dimension(65535, 26);
    private final String iconPath = "/org/gpsmaster/icons/dialogs/";

    public NameSearchPanel(MessageCenter messageCenter) {
        this.pin = new PinMarker(0.0, 0.0);
        this.msg = messageCenter;
        this.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(26, 22);
        this.entryPanel = new JPanel();
        this.entryPanel.setLayout(new BoxLayout(this.entryPanel, 2));
        this.textField = new JTextField();
        this.textField.setMaximumSize(new Dimension(65535, 22));
        this.textField.setToolTipText("Search place by name");
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (NameSearchPanel.this.textField.getText().length() >= 3) {
                    NameSearchPanel.this.searchButton.setEnabled(true);
                } else {
                    NameSearchPanel.this.searchButton.setEnabled(false);
                }
            }
        });
        this.entryPanel.add(this.textField);
        this.searchIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/search.png"));
        this.searchMoreIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/search-more.png"));
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/search-clear.png")));
        jButton.setToolTipText("clear search");
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameSearchPanel.this.clearEntryPanel();
                NameSearchPanel.this.tableOff();
                NameSearchPanel.this.resizePanel();
            }
        });
        this.entryPanel.add(jButton);
        this.wptButton = new JButton();
        this.wptButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/search-add.png")));
        this.wptButton.setToolTipText("add as waypoint");
        this.wptButton.setMinimumSize(dimension);
        this.wptButton.setPreferredSize(dimension);
        this.wptButton.setMaximumSize(dimension);
        this.wptButton.setEnabled(false);
        this.wptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameSearchPanel.this.addWaypoint(NameSearchPanel.this.resultModel.getPlace(NameSearchPanel.this.resultTable.getSelectedRow()));
            }
        });
        this.entryPanel.add(this.wptButton);
        this.rptButton = new JButton();
        this.rptButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/route-add.png")));
        this.rptButton.setToolTipText("add as point to current route");
        this.rptButton.setMinimumSize(dimension);
        this.rptButton.setPreferredSize(dimension);
        this.rptButton.setMaximumSize(dimension);
        this.rptButton.setVisible(false);
        this.rptButton.setEnabled(false);
        this.rptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameSearchPanel.this.addRoutepoint(NameSearchPanel.this.resultModel.getPlace(NameSearchPanel.this.resultTable.getSelectedRow()));
            }
        });
        this.entryPanel.add(this.rptButton);
        this.searchButton = new JButton();
        this.searchButton.setIcon(this.searchIcon);
        this.searchButton.setToolTipText("Search place by name");
        this.searchButton.setMinimumSize(dimension);
        this.searchButton.setPreferredSize(dimension);
        this.searchButton.setMaximumSize(dimension);
        this.entryPanel.add(this.searchButton);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NameSearchPanel.this.isBusy) {
                    SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            NameSearchPanel.this.busyOn();
                            NameSearchPanel.this.result = NameSearchPanel.this.nominatim.lookup();
                            NameSearchPanel.this.attributionLabel.setText(NameSearchPanel.this.result.getAttribution());
                            if (NameSearchPanel.this.result.getPlaces().size() > 0) {
                                for (NominatimPlace nominatimPlace : NameSearchPanel.this.result.getPlaces()) {
                                    NameSearchPanel.this.resultModel.add(nominatimPlace);
                                }
                                NameSearchPanel.this.tableOn();
                                NameSearchPanel.this.resizePanel();
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            if (NameSearchPanel.this.nominatim.hasMore()) {
                                NameSearchPanel.this.searchButton.setIcon(NameSearchPanel.this.searchMoreIcon);
                                NameSearchPanel.this.searchButton.setToolTipText("get more results");
                            } else {
                                NameSearchPanel.this.searchButton.setIcon(NameSearchPanel.this.searchIcon);
                                NameSearchPanel.this.searchButton.setToolTipText("Search place by name");
                            }
                            NameSearchPanel.this.busyOff();
                        }
                    };
                    String string = NameSearchPanel.this.textField.getText();
                    if (!string.equals(NameSearchPanel.this.nominatim.getQueryString())) {
                        NameSearchPanel.this.nominatim.setQueryString(string);
                        NameSearchPanel.this.resultModel.clear();
                        NameSearchPanel.this.resultTable.clearSelection();
                        NameSearchPanel.this.wptButton.setEnabled(false);
                        NameSearchPanel.this.rptButton.setEnabled(false);
                    }
                    try {
                        swingWorker.execute();
                    }
                    catch (Exception exception) {
                        NameSearchPanel.this.tableOff();
                        NameSearchPanel.this.clearEntryPanel();
                        NameSearchPanel.this.msg.error(exception);
                    }
                }
            }
        };
        this.textField.addActionListener(this.actionListener);
        this.searchButton.addActionListener(this.actionListener);
        this.add((Component)this.entryPanel, "North");
        this.resultModel = new NameResultModel();
        this.resultTable = new JTable();
        this.resultTable.setModel(this.resultModel);
        this.resultTable.setTableHeader(null);
        this.resultTable.setSelectionMode(0);
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = NameSearchPanel.this.resultTable.getSelectedRow();
                if (!listSelectionEvent.getValueIsAdjusting() && n < NameSearchPanel.this.resultModel.getRowCount() && n >= 0) {
                    NominatimPlace nominatimPlace = NameSearchPanel.this.resultModel.getPlace(n);
                    NameSearchPanel.this.wptButton.setEnabled(true);
                    NameSearchPanel.this.rptButton.setEnabled(true);
                    GpsMaster.active.removeMarker(NameSearchPanel.this.pin);
                    NameSearchPanel.this.pin.setLat(nominatimPlace.getLat());
                    NameSearchPanel.this.pin.setLon(nominatimPlace.getLon());
                    GpsMaster.active.addMarker(NameSearchPanel.this.pin);
                    GpsMaster.active.centerMap(NameSearchPanel.this.pin);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.resultTable);
        this.scrollPane.setVisible(false);
        this.attributionLabel = new JLabel();
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.attributionLabel, "South");
        this.setMaximumSize(this.emptySize);
    }

    public boolean isResultsShowing() {
        return this.scrollPane.isVisible();
    }

    public void setRoutepointEnabled(boolean bl) {
        this.addRoutePoints = bl;
        if (bl) {
            this.rptButton.setVisible(true);
        } else {
            this.rptButton.setVisible(false);
        }
    }

    public boolean isRoutepointEnabled() {
        return this.addRoutePoints;
    }

    private void addWaypoint(NominatimPlace nominatimPlace) {
        WaypointMarker waypointMarker = new WaypointMarker(nominatimPlace.getLat(), nominatimPlace.getLon());
        waypointMarker.setName(nominatimPlace.getDisplayName());
        waypointMarker.setSrc("Nominatim");
        GPXFile gPXFile = GpsMaster.active.getGpxFile();
        if (gPXFile == null) {
            gPXFile = new GPXFile();
            gPXFile.setName("Nominatim");
            GpsMaster.active.addGpxFile(gPXFile);
            GpsMaster.active.refreshTree();
        }
        gPXFile.getWaypointGroup().addWaypoint(waypointMarker);
        GpsMaster.active.refresh();
        GpsMaster.active.repaintMap();
    }

    private void addRoutepoint(NominatimPlace nominatimPlace) {
        Waypoint waypoint = new Waypoint(nominatimPlace.getLat(), nominatimPlace.getLon());
        waypoint.setName(nominatimPlace.getDisplayName());
        this.firePropertyChange("addRoutept", null, waypoint);
    }

    private void tableOn() {
        this.scrollPane.setVisible(true);
        this.attributionLabel.setVisible(true);
    }

    private void tableOff() {
        this.scrollPane.setVisible(false);
        this.attributionLabel.setVisible(false);
        this.setMaximumSize(this.emptySize);
    }

    private void resizePanel() {
        System.out.println("resizing table");
        if (this.scrollPane.isVisible()) {
            int n = Math.min(5, this.resultModel.getRowCount());
            int n2 = this.resultTable.getRowHeight();
            int n3 = n * n2 + this.entryPanel.getHeight() + this.attributionLabel.getHeight();
            System.out.println("height=" + n3);
            Dimension dimension = new Dimension(this.getWidth(), n3);
            this.setPreferredSize(dimension);
            this.setMaximumSize(null);
        } else {
            this.setPreferredSize(this.emptySize);
            this.setMaximumSize(this.emptySize);
        }
        if (this.getParent() instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)this.getParent();
            jSplitPane.resetToPreferredSizes();
        }
        System.out.println("height now: " + this.getSize().height);
    }

    private void clearEntryPanel() {
        this.tableOff();
        this.textField.setText("");
        this.resultModel.clear();
        if (this.result != null) {
            this.result.clear();
        }
        this.searchButton.setIcon(this.searchIcon);
        this.wptButton.setEnabled(false);
        this.rptButton.setEnabled(false);
        GpsMaster.active.removeMarker(this.pin);
        GpsMaster.active.repaintMap();
    }

    private void busyOn() {
        Cursor cursor = new Cursor(3);
        this.searchButton.setCursor(cursor);
        this.textField.setCursor(cursor);
        this.searchButton.setEnabled(false);
        this.isBusy = true;
    }

    private void busyOff() {
        Cursor cursor = new Cursor(0);
        this.searchButton.setCursor(cursor);
        this.textField.setCursor(cursor);
        this.searchButton.setEnabled(true);
        this.isBusy = false;
    }
}

