/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.unit.UnitConverter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.filehub.TransferableItem;

public abstract class TransferableItemTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -9141345826973751141L;
    private final String ICONPATH = "/org/gpsmaster/icons/dialogs/";
    protected UnitConverter uc = null;
    protected Icon queuedIcon = null;
    protected Icon processingIcon = null;
    protected Icon okIcon = null;
    protected Icon warningIcon = null;
    protected Icon errorIcon = null;
    protected ArrayList<TransferableItem> itemList = new ArrayList();

    public TransferableItemTableModel() {
        this.queuedIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/".concat("state-queued.png")));
        this.processingIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/".concat("state-processing.png")));
        this.okIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/".concat("state-ok.png")));
        this.warningIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/".concat("state-warning.png")));
        this.errorIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/".concat("state-error.png")));
    }

    public TransferableItemTableModel(UnitConverter unitConverter) {
        this();
        this.uc = unitConverter;
    }

    public UnitConverter getUnitConverter() {
        return this.uc;
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public int getRowCount() {
        return this.itemList.size();
    }

    protected Icon getStatusIcon(TransferableItem transferableItem) {
        switch (transferableItem.getTransferState()) {
            case 1: {
                return this.queuedIcon;
            }
            case 3: {
                switch (transferableItem.getLog().getFailureState()) {
                    case 3: {
                        return this.errorIcon;
                    }
                    case 2: {
                        return this.warningIcon;
                    }
                }
                return this.okIcon;
            }
            case 2: {
                return this.processingIcon;
            }
        }
        return null;
    }

    public void addItem(TransferableItem transferableItem) {
        this.itemList.add(transferableItem);
        this.fireTableDataChanged();
    }

    public void addItems(ArrayList<TransferableItem> arrayList) {
        int n = this.itemList.size();
        if (arrayList != null && arrayList.size() > 0) {
            this.itemList.addAll(arrayList);
        }
        int n2 = this.itemList.size();
        if (n <= 0) {
            this.fireTableDataChanged();
        } else {
            this.fireTableRowsInserted(n, n2 - 1);
        }
    }

    public boolean isEmpty() {
        return this.itemList.size() == 0;
    }

    public TransferableItem getItem(int n) {
        return this.itemList.get(n);
    }

    public List<TransferableItem> getItemList() {
        return this.itemList;
    }

    public void refreshTrack(TransferableItem transferableItem) {
        int n = this.itemList.indexOf(transferableItem);
        if (n != -1) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void clear() {
        this.itemList.clear();
    }
}

