/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.elevation;

import eu.fuegenstein.util.IProgressReporter;
import eu.fuegenstein.util.ProgressInfo;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.SwingWorker;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.elevation.ElevationProvider;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.undo.IUndoable;

public class Corrector
implements IUndoable {
    private IProgressReporter reporter = null;
    private ProgressInfo groupProgress = null;
    private ProgressInfo totalProgress = null;
    private ElevationProvider provider = null;
    private List<WaypointGroup> groups = null;
    private boolean inBackground = false;
    private CorrectionTask task = null;
    private PropertyChangeListener changeListener = null;
    private Hashtable<Waypoint, Double> undoList = null;

    public Corrector(ElevationProvider elevationProvider) {
        this.provider = elevationProvider;
        this.provider.setInterpolation(true);
        this.groups = new ArrayList<WaypointGroup>();
        this.undoList = new Hashtable();
    }

    public IProgressReporter getProgressReporter() {
        return this.reporter;
    }

    public void setProgressReporter(IProgressReporter iProgressReporter) {
        this.reporter = iProgressReporter;
    }

    public ElevationProvider getElevationProvider() {
        return this.provider;
    }

    public void setChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public boolean isRunInBackground() {
        return this.inBackground;
    }

    public void setRunInBackground(boolean bl) {
        this.inBackground = bl;
    }

    public void setWaypointGroups(List<WaypointGroup> list) {
        this.groups.clear();
        for (WaypointGroup waypointGroup : list) {
            this.groups.add(waypointGroup);
        }
    }

    public boolean isCancelled() {
        if (this.task != null) {
            return this.task.isCancelled();
        }
        return false;
    }

    public void correct() {
        this.setupReporter();
        if (this.inBackground) {
            this.task = new CorrectionTask();
            if (this.changeListener != null) {
                this.task.addPropertyChangeListener(this.changeListener);
            }
            this.task.execute();
        }
    }

    @Override
    public String getUndoDescription() {
        return "Elevation Correction (" + this.provider.getName() + ")";
    }

    @Override
    public void undo() {
        for (WaypointGroup waypointGroup : this.groups) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                if (!this.undoList.containsKey(waypoint)) continue;
                waypoint.setEle(this.undoList.get(waypoint));
            }
            waypointGroup.updateAllProperties();
        }
    }

    public void clear() {
        this.groups.clear();
        this.undoList.clear();
        this.reporter.removeProgressItem(this.groupProgress);
        this.reporter.removeProgressItem(this.totalProgress);
        this.groupProgress = null;
        this.totalProgress = null;
    }

    private void imDone() {
        if (this.task.isCancelled()) {
            this.undo();
        } else {
            GpsMaster.active.addUndoOperation(this);
        }
    }

    private void setupReporter() {
        if (this.reporter != null) {
            int n = 0;
            for (int i = 0; i < this.groups.size(); ++i) {
                n += this.groups.get(i).getWaypoints().size();
            }
            String string = String.format("Correcting elevation of %d trackpoints in %d segments", n, this.groups.size());
            this.reporter.setTitle(string);
            this.reporter.setFooter(this.provider.getAttribution());
            this.groupProgress = new ProgressInfo();
            this.groupProgress.setMinValue(0);
            this.groupProgress.setMaxValue(this.groups.size());
            this.reporter.addProgressItem(this.groupProgress);
            this.totalProgress = new ProgressInfo();
            this.totalProgress.setMinValue(0);
            this.reporter.addProgressItem(this.totalProgress);
        }
    }

    private class CorrectionTask
    extends SwingWorker<Void, Progress> {
        int groupCtr = 0;

        private CorrectionTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            for (WaypointGroup waypointGroup : Corrector.this.groups) {
                ++this.groupCtr;
                List<Waypoint> list = waypointGroup.getWaypoints();
                Corrector.this.totalProgress.setMaxValue(list.size());
                for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                    Corrector.this.undoList.put(waypoint, waypoint.getEle());
                }
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    n2 = Math.min(n + Corrector.this.provider.getChunkSize(), list.size());
                    if (Corrector.this.reporter != null) {
                        this.publish(new Progress(this.groupCtr, n2));
                        if (Corrector.this.reporter.isCancelled()) {
                            this.cancel(true);
                        }
                    }
                    Corrector.this.provider.correctElevation(list.subList(n, n2));
                    n = n2 + 1;
                }
                waypointGroup.updateAllProperties();
            }
            return null;
        }

        @Override
        protected void process(List<Progress> list) {
            if (Corrector.this.reporter != null) {
                Progress progress = list.get(list.size() - 1);
                Corrector.this.groupProgress.setValue(progress.groups);
                Corrector.this.totalProgress.setValue(progress.total);
                Corrector.this.reporter.update();
            }
        }

        @Override
        protected void done() {
            Corrector.this.imDone();
            this.firePropertyChange("eleFinished", null, null);
        }
    }

    private class Progress {
        public int groups = 0;
        public int total = 0;

        public Progress(int n, int n2) {
            this.groups = n;
            this.total = n2;
        }
    }
}

