/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.elevation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gpsmaster.elevation.ElevationProvider;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class MapQuestProvider
implements ElevationProvider {
    private String baseUrl = "http://open.mapquestapi.com/elevation/v1/profile?";
    private final String NAME = "MapQuest";
    private final String ATTRIBUTION = "Elevation Data provided by MapQuest";
    private int CHUNKSIZE = 400;
    private Locale fmtLocale = new Locale("en", "US");
    private int cleanseFailed = 0;
    boolean interpolate = true;

    @Override
    public String getName() {
        return "MapQuest";
    }

    @Override
    public String getAttribution() {
        return "Elevation Data provided by MapQuest";
    }

    @Override
    public void setInterpolation(boolean bl) {
        this.interpolate = bl;
    }

    @Override
    public boolean isInterpolation() {
        return this.interpolate;
    }

    @Override
    public int getChunkSize() {
        return this.CHUNKSIZE;
    }

    @Override
    public int getFailed() {
        return this.cleanseFailed;
    }

    @Override
    public void correctElevation(Waypoint waypoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void correctElevation(List<Waypoint> list) throws Exception {
        this.correct(list);
    }

    private void correct(List<Waypoint> list) throws Exception {
        if (list.size() > this.CHUNKSIZE) {
            throw new IllegalArgumentException("chunk size exceeded");
        }
        String string = "";
        for (Waypoint waypoint : list) {
            string = string + String.format(this.fmtLocale, "%.6f,%.6f,", waypoint.getLat(), waypoint.getLon());
        }
        String string2 = string = string.substring(0, string.length() - 1);
        String string3 = null;
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        string3 = "key=1bAcGKAeLtJCNkwIbgo7kZrM0D48Dcjg" + String.format("&inFormat=%s&latLngCollection=%s&outFormat=%s&useFilter=%s", URLEncoder.encode("kvp", "UTF-8"), URLEncoder.encode(string2, "UTF-8"), URLEncoder.encode("xml", "UTF-8"), URLEncoder.encode("true", "UTF-8"));
        String string4 = this.baseUrl + string3;
        uRLConnection = new URL(string4).openConnection();
        uRLConnection.setRequestProperty("Accept-Charset", "UTF-8");
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        inputStream = uRLConnection.getInputStream();
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string5 = bufferedReader.readLine();
        while (string5 != null) {
            stringBuilder.append(string5);
            stringBuilder.append('\n');
            string5 = bufferedReader.readLine();
        }
        string5 = stringBuilder.toString();
        if (string5.contains("Given Route exceeds the maximum allowed distance")) {
            throw new IllegalArgumentException("Given Route exceeds the maximum allowed distance");
        }
        List<Double> list2 = this.getEleArrayFromXMLResponse(string5);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("Result size mismatch");
        }
        for (int i = 0; i < list2.size(); ++i) {
            list.get(i).setEle(list2.get(i));
        }
    }

    private void cleanse(WaypointGroup waypointGroup) {
        int n;
        List<Waypoint> list = waypointGroup.getWaypoints();
        double d = waypointGroup.getStart().getEle();
        double d2 = waypointGroup.getEnd().getEle();
        if (d == -32768.0) {
            for (n = 0; n < list.size(); ++n) {
                if (list.get(n).getEle() == -32768.0) continue;
                d = list.get(n).getEle();
                break;
            }
        }
        if (d2 == -32768.0) {
            for (n = list.size() - 1; n >= 0; --n) {
                if (list.get(n).getEle() == -32768.0) continue;
                d2 = list.get(n).getEle();
                break;
            }
        }
        if (d == -32768.0 && d2 == -32768.0) {
            ++this.cleanseFailed;
            return;
        }
        list.get(0).setEle(d);
        list.get(list.size() - 1).setEle(d2);
        for (n = 0; n < list.size(); ++n) {
            int n2;
            if (list.get(n).getEle() != -32768.0) continue;
            Waypoint waypoint = null;
            Waypoint waypoint2 = null;
            double d3 = 0.0;
            double d4 = 0.0;
            Waypoint waypoint3 = list.get(n);
            Waypoint waypoint4 = list.get(n);
            for (n2 = n - 1; n2 >= 0; --n2) {
                waypoint4 = waypoint3;
                waypoint3 = list.get(n2);
                d3 += waypoint3.getDistance(waypoint4);
                if (list.get(n2).getEle() == -32768.0) continue;
                waypoint = list.get(n2);
                break;
            }
            waypoint3 = list.get(n);
            waypoint4 = list.get(n);
            for (n2 = n + 1; n2 < list.size(); ++n2) {
                waypoint4 = waypoint3;
                waypoint3 = list.get(n2);
                d4 += waypoint3.getDistance(waypoint4);
                if (list.get(n2).getEle() == -32768.0) continue;
                waypoint2 = list.get(n2);
                break;
            }
            if (waypoint == null || waypoint2 == null) continue;
            double d5 = d3 + d4;
            double d6 = waypoint2.getEle() - waypoint.getEle();
            double d7 = d3 / d5 * d6 + waypoint.getEle();
            list.get(n).setEle(d7);
        }
    }

    private List<Double> getEleArrayFromXMLResponse(String string) throws XMLStreamException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(byteArrayInputStream, "ISO-8859-1");
        while (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
            if (xMLStreamReader.getEventType() != 1 || !xMLStreamReader.getLocalName().equals("height")) continue;
            xMLStreamReader.next();
            if (!xMLStreamReader.isCharacters()) continue;
            arrayList.add(Double.parseDouble(xMLStreamReader.getText()));
        }
        xMLStreamReader.close();
        return arrayList;
    }
}

