/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.filehub;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.util.IProgressReporter;
import eu.fuegenstein.util.ProgressInfo;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.IItemSource;
import org.gpsmaster.filehub.IItemTarget;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpsloader.GpsLoaderFactory;
import org.gpsmaster.gpxpanel.GPXFile;

public class FileHub {
    private String title = "Transfer";
    private MessageCenter msg = null;
    private IProgressReporter progressReporter = null;
    private ProgressInfo totalProgress = null;
    private IItemSource itemSource = null;
    private List<IItemTarget> itemTargets = null;
    private List<TransferableItem> processedItems = null;
    private List<GpsLoader> loaders = new ArrayList<GpsLoader>();
    private List<PropertyChangeListener> changeListeners = new ArrayList<PropertyChangeListener>();
    private SwingWorker<Void, Void> transferWorker = null;
    private GPXFile currentGpx = null;
    private byte[] streamBuffer = null;

    public FileHub() {
        this.itemTargets = new ArrayList<IItemTarget>();
        this.processedItems = Collections.synchronizedList(new ArrayList());
        this.makeTransferWorker();
    }

    public String getProgressTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public IItemSource getItemSource() {
        return this.itemSource;
    }

    public void setItemSource(IItemSource iItemSource) {
        this.itemSource = iItemSource;
    }

    public void addItem(TransferableItem transferableItem) {
        this.itemSource.getItems().add(transferableItem);
    }

    public void addItemTarget(IItemTarget iItemTarget) {
        this.itemTargets.add(iItemTarget);
    }

    public void removeItemTarget(IItemTarget iItemTarget) {
        this.itemTargets.remove(iItemTarget);
    }

    public void setItemTargets(List<IItemTarget> list) {
        this.itemTargets = list;
    }

    public List<IItemTarget> getItemTargets() {
        return this.itemTargets;
    }

    public IProgressReporter getProgressReporter() {
        return this.progressReporter;
    }

    public void setProgressReporter(IProgressReporter iProgressReporter) {
        this.progressReporter = iProgressReporter;
        String string = "Loading files";
        this.progressReporter.setTitle(string);
        this.totalProgress = new ProgressInfo();
        this.totalProgress.setMinValue(0);
        this.progressReporter.addProgressItem(this.totalProgress);
    }

    public MessageCenter getMessageCenter() {
        return this.msg;
    }

    public void setMessageCenter(MessageCenter messageCenter) {
        this.msg = messageCenter;
    }

    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.changeListeners.contains(propertyChangeListener)) {
            this.changeListeners.add(propertyChangeListener);
        }
    }

    public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeListeners.contains(propertyChangeListener)) {
            this.changeListeners.remove(propertyChangeListener);
        }
        if (this.transferWorker.getState() != SwingWorker.StateValue.DONE) {
            this.transferWorker.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public List<TransferableItem> getProcessedItems() {
        return this.processedItems;
    }

    public void run() {
        if (this.itemSource == null) {
            throw new IllegalArgumentException("No item source set");
        }
        if (this.transferWorker.getState() == SwingWorker.StateValue.DONE) {
            this.makeTransferWorker();
        }
        for (PropertyChangeListener propertyChangeListener : this.changeListeners) {
            this.transferWorker.removePropertyChangeListener(propertyChangeListener);
            this.transferWorker.addPropertyChangeListener(propertyChangeListener);
        }
        if (this.progressReporter != null) {
            this.progressReporter.setTitle("Transferring ...");
        }
        this.transferWorker.execute();
    }

    public void cancel() {
        if (this.transferWorker != null) {
            this.transferWorker.cancel(true);
        }
        if (this.progressReporter != null) {
            this.progressReporter.cancel();
        }
    }

    public boolean isCancelled() {
        return this.transferWorker.isCancelled();
    }

    public void clear() {
        this.loaders.clear();
        this.processedItems.clear();
        this.changeListeners.clear();
    }

    private void makeTransferWorker() {
        this.transferWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                int n = 0;
                if (FileHub.this.progressReporter != null) {
                    FileHub.this.progressReporter.reset();
                }
                int n2 = FileHub.this.itemSource.getItems().size();
                this.firePropertyChange("transferStarted", null, null);
                while (n < n2 && !this.isCancelled()) {
                    TransferableItem transferableItem = FileHub.this.itemSource.getItems().get(n);
                    FileHub.this.setProgressTitle("Getting " + transferableItem.getName() + " from " + FileHub.this.itemSource.getName());
                    if (FileHub.this.progressReporter != null) {
                        FileHub.this.totalProgress.setMaxValue(FileHub.this.processedItems.size() + FileHub.this.itemSource.getItems().size());
                        FileHub.this.totalProgress.incrementValue();
                        FileHub.this.progressReporter.update();
                        if (FileHub.this.progressReporter.isCancelled()) {
                            this.cancel(true);
                        }
                    }
                    transferableItem.setTransferState(2);
                    this.firePropertyChange("transferItemStateChanged", null, transferableItem);
                    try {
                        if (FileHub.this.itemSource.getDataType() == DataType.STREAM) {
                            FileHub.this.itemSource.open(transferableItem);
                            FileHub.access$502(FileHub.this, IOUtils.toByteArray((InputStream)FileHub.this.itemSource.getInputStream()));
                            FileHub.this.itemSource.close();
                        }
                        for (IItemTarget iItemTarget : FileHub.this.itemTargets) {
                            if (!iItemTarget.isEnabled()) continue;
                            if (iItemTarget.doShowProgressText()) {
                                FileHub.this.setProgressTitle("Sending " + transferableItem.getName() + " to " + iItemTarget.getName());
                            }
                            try {
                                FileHub.this.dispatch(transferableItem, FileHub.this.itemSource, iItemTarget);
                            }
                            catch (Exception exception) {
                                transferableItem.log.addEntry(3, "sending to " + iItemTarget.getName() + " failed", exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        transferableItem.getLog().addEntry(3, "loading from " + FileHub.this.itemSource.getName() + " failed", exception);
                    }
                    FileHub.this.processedItems.add(transferableItem);
                    transferableItem.setTransferState(3);
                    FileHub.this.currentGpx = null;
                    FileHub.access$502(FileHub.this, null);
                    this.firePropertyChange("transferItemStateChanged", null, transferableItem);
                    ++n;
                    n2 = FileHub.this.itemSource.getItems().size();
                }
                return null;
            }

            @Override
            protected void done() {
                this.firePropertyChange("transferFinished", null, null);
                FileHub.this.loaders.clear();
            }
        };
    }

    private void dispatch(TransferableItem transferableItem, IItemSource iItemSource, IItemTarget iItemTarget) throws Exception {
        if (iItemTarget.isEnabled()) {
            if (iItemSource.getDataType() == DataType.GPXFILE && iItemTarget.getDataType() == DataType.GPXFILE) {
                iItemTarget.addGpxFile(iItemSource.getGpxFile(transferableItem), transferableItem);
            } else if (iItemSource.getDataType() == DataType.STREAM && iItemTarget.getDataType() == DataType.GPXFILE) {
                this.streamToGpx(transferableItem, this.streamBuffer);
                iItemTarget.addGpxFile(this.currentGpx, transferableItem);
            } else if (iItemSource.getDataType() == DataType.GPXFILE && iItemTarget.getDataType() == DataType.STREAM) {
                this.gpxToStream(transferableItem, iItemSource.getGpxFile(transferableItem), iItemTarget);
            } else if (iItemSource.getDataType() == DataType.STREAM && iItemTarget.getDataType() == DataType.STREAM) {
                this.streamToStream(transferableItem, this.streamBuffer, iItemTarget);
            } else if (iItemSource.getDataType() == DataType.STREAM && iItemTarget.getDataType() == DataType.STREAMGPX) {
                this.streamToGpx(transferableItem, this.streamBuffer);
                this.streamToStreamGpx(transferableItem, iItemTarget);
            } else if (iItemSource.getDataType() == DataType.GPXFILE && iItemTarget.getDataType() == DataType.STREAMGPX) {
                this.gpxToStreamGpx(transferableItem, iItemSource.getGpxFile(transferableItem), iItemTarget);
            } else {
                throw new UnsupportedOperationException("Source/Target DataType combination not supported");
            }
        }
    }

    private void streamToGpx(TransferableItem transferableItem, byte[] byArray) throws Exception {
        GpsLoader gpsLoader = null;
        if (this.currentGpx == null) {
            if (transferableItem.getLoaderClassName() != null) {
                gpsLoader = GpsLoaderFactory.getLoaderByClassName(transferableItem.getLoaderClassName());
            } else if (transferableItem.getSourceFormat() != null) {
                gpsLoader = GpsLoaderFactory.getLoaderByExtension(transferableItem.getSourceFormat());
            }
            if (gpsLoader == null) {
                throw new IllegalArgumentException("unknown file type / loader class");
            }
            transferableItem.setLoaderClassName(gpsLoader.getClass().getName());
            if (gpsLoader.canValidate()) {
                try {
                    gpsLoader.validate(new ByteArrayInputStream(byArray));
                }
                catch (Exception exception) {
                    transferableItem.getLog().addEntry(2, "validation failed", exception);
                }
            }
            this.currentGpx = gpsLoader.load(new ByteArrayInputStream(byArray), transferableItem.getSourceFormat());
        }
    }

    private void streamToStream(TransferableItem transferableItem, byte[] byArray, IItemTarget iItemTarget) throws Exception {
        iItemTarget.open(transferableItem);
        iItemTarget.getOutputStream().write(byArray);
        iItemTarget.close();
    }

    private void streamToStreamGpx(TransferableItem transferableItem, IItemTarget iItemTarget) throws IOException, Exception {
        iItemTarget.open(transferableItem);
        iItemTarget.addGpxFile(this.currentGpx, transferableItem);
        iItemTarget.getOutputStream().write(this.streamBuffer);
        iItemTarget.close();
    }

    private void gpxToStreamGpx(TransferableItem transferableItem, GPXFile gPXFile, IItemTarget iItemTarget) throws IOException, Exception {
        String string = iItemTarget.getRequiredFormat();
        if (string == null) {
            string = transferableItem.getSourceFormat();
        }
        GpsLoader gpsLoader = GpsLoaderFactory.getLoaderByExtension(string);
        iItemTarget.open(transferableItem);
        iItemTarget.addGpxFile(gPXFile, transferableItem);
        gpsLoader.save(gPXFile, iItemTarget.getOutputStream());
        iItemTarget.close();
    }

    private void gpxToStream(TransferableItem transferableItem, GPXFile gPXFile, IItemTarget iItemTarget) throws Exception {
        String string = iItemTarget.getRequiredFormat();
        if (string == null) {
            string = transferableItem.getSourceFormat();
        }
        GpsLoader gpsLoader = GpsLoaderFactory.getLoaderByExtension(string);
        iItemTarget.open(transferableItem);
        gpsLoader.save(gPXFile, iItemTarget.getOutputStream());
        iItemTarget.close();
    }

    private void setProgressTitle(String string) {
        if (this.progressReporter != null) {
            this.totalProgress.setName(string);
        }
    }

    public void finalize() {
        System.out.println("disposing FileHub");
    }

    static /* synthetic */ byte[] access$502(FileHub fileHub, byte[] byArray) {
        fileHub.streamBuffer = byArray;
        return byArray;
    }
}

