/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javolution.io.Struct;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.joda.time.DateTime;

public class CpoLoader
extends GpsLoader {
    private final double LATLONSCALE = 1000000.0;
    private final int WORKOUTSIZE = 80;
    private final int LAPSIZE = 44;
    private long pointRecs = 0L;
    private DateTime gpsDate = null;
    private int lapNum = 0;
    private List<Lap> laps = new ArrayList<Lap>();

    public CpoLoader() {
        this.extensions.add("cpo");
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        if (!inputStream.markSupported()) {
            throw new IOException("unspported stream type");
        }
        int n = inputStream.available();
        this.gpx = new GPXFile();
        this.gpx.addExtensionPrefix("hrm");
        inputStream.mark(n);
        this.skipBytes(inputStream, n - 80);
        this.readWorkout(inputStream);
        inputStream.reset();
        this.skipBytes(inputStream, n - 80 - 44 * this.lapNum);
        this.readLaps(inputStream);
        inputStream.reset();
        this.readPoints(inputStream);
        inputStream.close();
        return this.gpx;
    }

    private void readWorkout(InputStream inputStream) throws IOException {
        Workout workout = new Workout();
        workout.read(inputStream);
        this.pointRecs = workout.totalRecPt.get();
        this.gpx.setCreator(String.format("%s v%d", workout.product.get(), workout.verNum.get()));
        this.gpsDate = new DateTime(workout.dateYear.get() + 2000, (int)workout.dateMonth.get(), (int)workout.dateDay.get(), (int)workout.timeHour.get(), (int)workout.timeMinute.get(), (int)workout.timeSecond.get());
        this.gpx.getMetadata().setTime(this.gpsDate.toDate());
        int n = workout.calory.get();
        if (n > 0) {
            this.gpx.getExtension().add(new GPXExtension("hrm:calories", Integer.toString(n)));
        }
        this.lapNum = workout.lapNum.get();
    }

    private void readLaps(InputStream inputStream) throws IOException {
        for (int i = 0; i < this.lapNum; ++i) {
            Lap lap = new Lap();
            lap.read(inputStream);
            this.laps.add(lap);
        }
    }

    private void readPoints(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        WaypointGroup waypointGroup = null;
        Track track = new Track(this.gpx.getColor());
        this.gpx.addTrack(track);
        Point point = new Point();
        Waypoint waypoint = null;
        int n4 = 0;
        while ((long)n4 < this.pointRecs) {
            if (n4 == n) {
                waypointGroup = track.addTrackseg();
                if (waypoint != null) {
                    waypointGroup.addWaypoint(waypoint);
                }
                if (++n2 < this.laps.size()) {
                    n = this.laps.get((int)n2).endPt.get();
                }
                waypointGroup.setName(String.format("Lap %d", n2));
            }
            point.read(inputStream);
            double d = (double)point.lat.get() / 1000000.0;
            double d2 = (double)point.lon.get() / 1000000.0;
            waypoint = new Waypoint(d, d2);
            waypoint.setEle(point.alt.get());
            waypoint.setTime(this.gpsDate.plusMillis(n3 * 100).toDate());
            this.addExtIfNotZero(waypoint, "speed", (float)point.gpsSpeed.get() / 100.0f);
            this.addExtIfNotZero(waypoint, "hrm:hr", point.hrHr.get());
            this.addExtIfNotZero(waypoint, "hrm:speed", point.speedSpeed.get());
            this.addExtIfNotZero(waypoint, "hrm:cadence", point.cadCadence.get());
            this.addExtIfNotZero(waypoint, "hrm:power", point.pwrPower.get());
            Byte by = point.temp.get();
            if (by != -127) {
                this.addExtIfNotZero(waypoint, "hrm:temp", by.byteValue());
            }
            waypointGroup.addWaypoint(waypoint);
            n3 += point.intTime.get();
            ++n4;
        }
    }

    private void addExtIfNotZero(Waypoint waypoint, String string, long l) {
        if (l != 0L) {
            waypoint.getExtension().add(string, String.format("%d", l));
        }
    }

    private void addExtIfNotZero(Waypoint waypoint, String string, double d) {
        if (d != 0.0) {
            waypoint.getExtension().add(string, String.format(this.numLocale, "%.2f", d));
        }
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canValidate() {
        return false;
    }

    @Override
    public void validate(InputStream inputStream) {
    }

    @Override
    public void clear() {
        super.clear();
        this.laps.clear();
    }

    private final int skipBytes(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)inputStream.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    private static class Point
    extends Struct {
        public final Struct.Signed32 lat = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 lon = new Struct.Signed32((Struct)this);
        public final Struct.Unsigned16 alt = new Struct.Unsigned16((Struct)this);
        public final Struct.Signed16 res1 = new Struct.Signed16((Struct)this);
        public final Struct.Signed32 gpsSpeed = new Struct.Signed32((Struct)this);
        public final Struct.Unsigned16 intDist = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 res2 = new Struct.Unsigned16((Struct)this);
        public final Struct.Signed32 intTime = new Struct.Signed32((Struct)this);
        public final Struct.Unsigned8 gpsStatus = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 hrHr = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 hrStatus = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 res3 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned32 speedSpeed = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned8 speedStatus = new Struct.Unsigned8((Struct)this);
        public final Struct.UTF8String speedRes = new Struct.UTF8String((Struct)this, 3);
        public final Struct.Unsigned8 cadCadence = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 cadStatus = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 pwrCadence = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 pwrPower = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned8 pwrStatus = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 res4 = new Struct.Unsigned8((Struct)this);
        public final Struct.Signed8 temp = new Struct.Signed8((Struct)this);
        public final Struct.UTF8String dummy = new Struct.UTF8String((Struct)this, 3);

        private Point() {
        }

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    private static class Workout
    extends Struct {
        public final Struct.Unsigned8 dateYear = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 dateMonth = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 dateDay = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 timeHour = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 timeMinute = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 timeSecond = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned16 totalRecPt = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 totalTime = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned32 totalDist = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned16 lapNum = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 calory = new Struct.Unsigned16((Struct)this);
        public final Struct.UTF8String res2 = new Struct.UTF8String((Struct)this, 24);
        public final Struct.UTF8String product = new Struct.UTF8String((Struct)this, 15);
        public final Struct.Unsigned16 verNum = new Struct.Unsigned16((Struct)this);

        private Workout() {
        }

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    private static class Lap
    extends Struct {
        public final Struct.Unsigned32 splitTime = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned32 totalTime = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned16 number = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned32 distance = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned16 calory = new Struct.Unsigned16((Struct)this);
        public final Struct.UTF8String res1 = new Struct.UTF8String((Struct)this, 20);
        public final Struct.Unsigned16 startPt = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 endPt = new Struct.Unsigned16((Struct)this);

        private Lap() {
        }

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }
}

