/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.NotBoundException;
import javax.xml.bind.ValidationException;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.marker.WaypointMarker;

public class CsvLoader
extends GpsLoader {
    private int latIdx = -1;
    private int lonIdx = -1;
    private int altIdx = -1;
    private int devIdx = -1;
    private int ouiIdx = -1;
    private int macIdx = -1;
    private WaypointMarker wpt = null;

    public CsvLoader() {
        this.isAdding = false;
        this.isDefault = false;
        this.extensions.add("csv");
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        String string2 = null;
        GPXFile gPXFile = new GPXFile();
        Track track = new Track(gPXFile.getColor());
        gPXFile.addTrack(track);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        string2 = bufferedReader.readLine();
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("latitude")) {
                this.latIdx = i;
            }
            if (stringArray[i].equals("longitude")) {
                this.lonIdx = i;
            }
            if (stringArray[i].equals("altitude")) {
                this.altIdx = i;
            }
            if (stringArray[i].equals("deviceName")) {
                this.devIdx = i;
            }
            if (stringArray[i].equals("oui_name")) {
                this.ouiIdx = i;
            }
            if (!stringArray[i].equals("deviceAddress")) continue;
            this.macIdx = i;
        }
        if (this.latIdx == -1 || this.lonIdx == -1) {
            throw new Exception("missing lat/lon column name");
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            stringArray = string2.split(",");
            double d = Double.parseDouble(stringArray[this.latIdx]);
            double d2 = Double.parseDouble(stringArray[this.lonIdx]);
            this.wpt = new WaypointMarker(d, d2);
            String string3 = "";
            if (this.devIdx != -1) {
                string3 = string3 + stringArray[this.devIdx];
            }
            if (this.ouiIdx != -1) {
                string3 = string3 + " " + stringArray[this.ouiIdx];
            }
            this.wpt.setName(string3);
            gPXFile.getWaypointGroup().addWaypoint(this.wpt);
        }
        return gPXFile;
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
    }

    @Override
    public boolean canValidate() {
        return false;
    }

    @Override
    public void validate(InputStream inputStream) throws ValidationException, NotBoundException {
    }
}

