/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.bind.ValidationException;
import javolution.io.Struct;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FitLoader
extends GpsLoader {
    private int currentLoadColor = 0;

    FitLoader() {
        this.isAdding = false;
        this.isDefault = false;
        this.extensions.add("fit");
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        this.gpx = new GPXFile();
        FitParser fitParser = new FitParser();
        fitParser.parseFitFile(inputStream);
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
        Integer n = fitParser.getLaps();
        for (int i = 0; i < n; ++i) {
            ArrayList<FitParser.FitRecord> arrayList = fitParser.getLapRecords(i);
            if (null == arrayList || arrayList.isEmpty()) continue;
            Track track = new Track(this.gpx.getColor(this.currentLoadColor++));
            track.setName(dateTimeFormatter.print((ReadableInstant)arrayList.get((int)0).timestamp));
            WaypointGroup waypointGroup = track.addTrackseg();
            fitParser.generateWaypoints(arrayList, waypointGroup, this.gpx);
            if (waypointGroup.getNumPts() != 0) {
                this.gpx.addTrack(track);
                continue;
            }
            throw new ValidationException("FIT file contained no usable track information!");
        }
        this.gpx.setCreator(fitParser.getCreator());
        this.gpx.setName(fitParser.getName());
        return this.gpx;
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate(InputStream inputStream) throws ValidationException {
        try {
            FitParser fitParser = new FitParser();
            fitParser.validateFitFile(inputStream);
        }
        catch (Exception exception) {
            System.err.println("Exception during validation.");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw new ValidationException(exception.getMessage());
        }
    }

    @Override
    public boolean canValidate() {
        return true;
    }

    static class FitParser {
        private static final Integer TIMESTAMP_FIELD = 253;
        private static final int FILEID_MSG = 0;
        private static final Integer FILEID_FIELD_TYPE = 0;
        private static final Integer FILEID_FIELD_SERIAL = 3;
        private static final Integer FILEID_FIELD_CREATETIME = 4;
        private static final Integer FILEID_TYPE_ACTIVITY = 4;
        private static final int CREATOR_MSG = 49;
        private static final Integer CREATOR_FIELD_SVERSION = 0;
        private static final Integer CREATOR_FIELD_HVERSION = 1;
        private static final int HRV_MSG = 78;
        private static final Integer HRV_FIELD_TIME = 0;
        private static final Integer HRV_TIME_SCALE = 1000;
        private static final int RECORD_MSG = 20;
        private static final Integer RECORD_FIELD_TIMESTAMP = TIMESTAMP_FIELD;
        private static final Integer RECORD_FIELD_POS_LAT = 0;
        private static final Integer RECORD_FIELD_POS_LONG = 1;
        private static final Integer RECORD_FIELD_ALTITUDE = 2;
        private static final Integer RECORD_FIELD_HEARTRATE = 3;
        private static final Integer RECORD_FIELD_CADENCE = 4;
        private static final Integer RECORD_FIELD_ENHANCED_SPEED = 73;
        private static final Integer RECORD_FIELD_TEMPERATURE = 13;
        private static final Integer RECORD_FIELD_ZONE = 50;
        private static final Integer RECORD_ALTITUDE_SCALE = 5;
        private static final Integer RECORD_ALTITUDE_OFFSET = -500;
        private static final Integer RECORD_ENHANCED_SPEED_SCALE = 1000;
        private static final int LAP_MSG = 19;
        private static final Integer LAP_FIELD_INDEX = 254;
        private static final Integer LAP_FIELD_TIMESTAMP = TIMESTAMP_FIELD;
        private static final Integer LAP_FIELD_EVENT = 0;
        private static final Integer LAP_FIELD_EVENTTYPE = 1;
        private static final int FIELD_TYPE_ENUM = 0;
        private static final int FIELD_TYPE_SINT8 = 1;
        private static final int FIELD_TYPE_UINT8 = 2;
        private static final int FIELD_TYPE_SINT16 = 3;
        private static final int FIELD_TYPE_UINT16 = 4;
        private static final int FIELD_TYPE_SINT32 = 5;
        private static final int FIELD_TYPE_UINT32 = 6;
        private static final int FIELD_TYPE_STRING = 7;
        private static final int FIELD_TYPE_FLOAT32 = 8;
        private static final int FIELD_TYPE_FLOAT64 = 9;
        private static final int FIELD_TYPE_UINT8Z = 10;
        private static final int FIELD_TYPE_UINT16Z = 11;
        private static final int FIELD_TYPE_UINT32Z = 12;
        private static final int FIELD_TYPE_BYTE = 13;
        private static final int FIELD_TYPE_SINT64 = 14;
        private static final int FIELD_TYPE_UINT64 = 15;
        private static final int FIELD_TYPE_UINT64Z = 16;
        private String creator = new String("");
        private String name = new String("");
        private Double lastHrv = 0.0;
        private ArrayList<ArrayList<FitRecord>> laps = new ArrayList(256);
        private ArrayList<FitRecord> records = new ArrayList(262144);
        private Integer lap = 1;
        private HashMap<Integer, FitDataMessage> messageDefinitions = new HashMap(16);

        FitParser() {
        }

        public String getCreator() {
            return this.creator;
        }

        public String getName() {
            return this.name;
        }

        public Integer getLaps() {
            return this.lap;
        }

        public ArrayList<FitRecord> getLapRecords(Integer n) {
            return this.laps.get(n);
        }

        private Double convertSemicirclesToDegree(Integer n) {
            Double d = (double)n.intValue() * (180.0 / Math.pow(2.0, 31.0));
            return d;
        }

        private Integer convertDegreeToSemicircles(Double d) {
            Integer n = (int)Math.round(d * Math.pow(2.0, 31.0));
            return n;
        }

        public DateTime convertToJodaTime(Integer n) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.set(5, 31);
            calendar.set(2, 11);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.set(1, 1989);
            calendar.add(13, n);
            return new DateTime((Object)calendar.getTime(), DateTimeZone.UTC);
        }

        public void validateFitFile(InputStream inputStream) throws IOException, ValidationException {
            byte[] byArray;
            int n;
            FitCrc fitCrc;
            Crc crc = new Crc();
            FitHeader fitHeader = new FitHeader();
            fitHeader.read(inputStream, crc);
            if (fitHeader.dataType.get() != 1414088238L) {
                throw new ValidationException("File is not a FIT file!");
            }
            Long l = fitHeader.dataSize.get();
            if (14 == fitHeader.headerSize.get()) {
                long l2 = crc.getValue();
                fitCrc = new FitCrc();
                fitCrc.read(inputStream, crc);
                if (fitCrc.fitCrc.get() != 0 && (long)fitCrc.fitCrc.get() != l2) {
                    throw new ValidationException("FIT header CRC mismatch. Expected:" + Integer.toHexString(fitCrc.fitCrc.get()) + " but calculated:" + Long.toHexString(crc.getValue()));
                }
            }
            if ((n = inputStream.read(byArray = new byte[l.intValue()])) != l.intValue()) {
                throw new ValidationException("Failed to read all data. Read:" + n + " but expected:" + l);
            }
            crc.calculate(byArray);
            fitCrc = new FitCrc();
            fitCrc.read(inputStream);
            if (crc.getValue() == 0L || (long)fitCrc.fitCrc.get() != crc.getValue()) {
                throw new ValidationException("FIT file CRC mismatch. Expected:" + Integer.toHexString(fitCrc.fitCrc.get()) + " but calculated:" + Long.toHexString(crc.getValue()));
            }
        }

        public void parseFitFile(InputStream inputStream) throws IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ValidationException {
            Object object;
            FitStructPacked fitStructPacked;
            long l;
            this.lap = 0;
            this.laps.clear();
            this.records.clear();
            Crc crc = new Crc();
            FitHeader fitHeader = new FitHeader();
            fitHeader.read(inputStream, crc);
            Boolean bl = fitHeader.dataType.get() == 1414088238L;
            Long l2 = fitHeader.dataSize.get();
            System.err.println("  Bytes to read: " + l2);
            if (14 == fitHeader.headerSize.get()) {
                l = crc.getValue();
                fitStructPacked = new FitCrc();
                fitStructPacked.read(inputStream, crc);
                if (((FitCrc)fitStructPacked).fitCrc.get() != 0 && (long)((FitCrc)fitStructPacked).fitCrc.get() != l) {
                    throw new ValidationException("FIT header CRC mismatch. Expected:" + Integer.toHexString(((FitCrc)fitStructPacked).fitCrc.get()) + " but calculated:" + Long.toHexString(l));
                }
            }
            if (!bl.booleanValue()) {
                System.err.println("File is not a FIT file!");
                throw new ValidationException("File is not a FIT file!");
            }
            l = 0L;
            fitStructPacked = new FitRecordHeader();
            FitCompressedHeader fitCompressedHeader = new FitCompressedHeader();
            Integer n = -1;
            Boolean bl2 = false;
            FitDefinitionMessageContentFixed fitDefinitionMessageContentFixed = new FitDefinitionMessageContentFixed(true);
            FitDefinitionField fitDefinitionField = new FitDefinitionField(true);
            FitDefinitionFieldBaseType fitDefinitionFieldBaseType = new FitDefinitionFieldBaseType(true);
            FitByte fitByte = new FitByte();
            FitByte fitByte2 = new FitByte();
            FitByte fitByte3 = new FitByte();
            block7: while (0 != inputStream.available() && l < l2) {
                Object object2;
                Object object3;
                Object object4;
                fitStructPacked.read(inputStream, crc);
                l += (long)fitStructPacked.size();
                if (0 == ((FitRecordHeader)fitStructPacked).normal.shortValue()) {
                    bl2 = false;
                    n = ((FitRecordHeader)fitStructPacked).localMessageType.intValue();
                    if (1 == ((FitRecordHeader)fitStructPacked).messageType.shortValue()) {
                        int n2;
                        l += (long)fitByte.read(inputStream, crc);
                        l += (long)fitByte2.read(inputStream, crc);
                        object = 0 == fitByte2.fitByte.get();
                        fitDefinitionMessageContentFixed.setEndian((Boolean)object);
                        l += (long)fitDefinitionMessageContentFixed.read(inputStream, crc);
                        object4 = new FitDataMessage(fitDefinitionMessageContentFixed.globalMsgNum.get(), ((FitRecordHeader)fitStructPacked).localMessageType.intValue(), Integer.valueOf(fitDefinitionMessageContentFixed.numberOfFields.get()));
                        this.messageDefinitions.put(((FitDataMessage)object4).localMessageNumber, (FitDataMessage)object4);
                        for (n2 = 0; n2 < fitDefinitionMessageContentFixed.numberOfFields.get(); ++n2) {
                            fitDefinitionField.setEndian((Boolean)object);
                            l += (long)fitDefinitionField.read(inputStream, crc);
                            fitDefinitionFieldBaseType.setEndian((Boolean)object);
                            l += (long)fitDefinitionFieldBaseType.read(inputStream, crc);
                            object3 = FitDataTypes.getBaseType(fitDefinitionFieldBaseType.baseTypeNumber.intValue());
                            object2 = new FitDataMessageField(Integer.valueOf(fitDefinitionField.fieldDefinitionNumber.get()), Integer.valueOf(fitDefinitionField.size.get()), (Boolean)object, (FitBaseType)object3);
                            ((FitDataMessage)object4).addField((FitDataMessageField)object2);
                        }
                        if (0 == ((FitRecordHeader)fitStructPacked).devDataFlag.intValue()) continue;
                        l += (long)fitByte3.read(inputStream, crc);
                        ((FitDataMessage)object4).addDevFields(fitByte3.fitByte.get());
                        for (n2 = 0; n2 < fitByte3.fitByte.get(); ++n2) {
                            fitDefinitionField.setEndian((Boolean)object);
                            l += (long)fitDefinitionField.read(inputStream, crc);
                            fitDefinitionFieldBaseType.setEndian((Boolean)object);
                            l += (long)fitDefinitionFieldBaseType.read(inputStream, crc);
                            object3 = FitDataTypes.getBaseType(fitDefinitionFieldBaseType.baseTypeNumber.intValue());
                            object2 = new FitDataMessageField(Integer.valueOf(fitDefinitionField.fieldDefinitionNumber.get()), Integer.valueOf(fitDefinitionField.size.get()), (Boolean)object, (FitBaseType)object3);
                            ((FitDataMessage)object4).addDevField((FitDataMessageField)object2);
                        }
                        continue;
                    }
                } else {
                    bl2 = true;
                    fitCompressedHeader.setByteBuffer(fitStructPacked.getByteBuffer(), 0);
                    if (1 != fitCompressedHeader.normal.shortValue()) {
                        System.err.println("Failed to set compressed header content");
                        throw new ValidationException("Failed to set compressed header content");
                    }
                    n = fitCompressedHeader.localMessageType.intValue();
                }
                if (null == (object = this.messageDefinitions.get(n))) {
                    System.err.println("Invalid FIT structure. Data message references unknown definition message.");
                    throw new ValidationException("Invalid FIT structure. Data message references unknown definition message.");
                }
                l += (long)((FitDataMessage)object).read(inputStream, bl2, crc).intValue();
                switch (((FitDataMessage)object).globalMessageNumber) {
                    case 0: {
                        object4 = ((FitDataMessage)object).getField(FILEID_FIELD_TYPE);
                        if (null != object4) {
                            if (!((FitDataMessageField)object4).asString().equals(FILEID_TYPE_ACTIVITY.toString())) {
                                System.err.println("FIT file is not an activity file. Unable to proceed!");
                                this.records.clear();
                                throw new ValidationException("FIT file is not an activity file. Unable to proceed!");
                            }
                            System.out.println("FIT activity file detected!");
                        }
                        if (null != (object4 = ((FitDataMessage)object).getField(FILEID_FIELD_CREATETIME))) {
                            DateTime dateTime = this.convertToJodaTime(((FitDataMessageField)object4).asInteger());
                            object3 = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss Z");
                            this.name = object3.print((ReadableInstant)dateTime);
                        }
                        if (null == (object4 = ((FitDataMessage)object).getField(FILEID_FIELD_SERIAL)) || ((FitDataMessageField)object4).isInvalid().booleanValue()) continue block7;
                        this.creator = ((FitDataMessageField)object4).asString();
                        break;
                    }
                    case 78: {
                        object4 = ((FitDataMessage)object).getField(HRV_FIELD_TIME);
                        if (null == object4) continue block7;
                        Integer n3 = ((FitDataMessageField)object4).asInteger();
                        object3 = 1.0 * (double)n3.intValue() / (double)HRV_TIME_SCALE.intValue();
                        this.lastHrv = object3;
                        break;
                    }
                    case 20: {
                        object4 = new FitRecord();
                        ((FitRecord)object4).hrv = this.lastHrv;
                        FitDataMessageField fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_POS_LAT);
                        if (null != fitDataMessageField) {
                            object3 = fitDataMessageField.asInteger();
                            object2 = this.convertSemicirclesToDegree((Integer)object3);
                            ((FitRecord)object4).posLat = object2;
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_POS_LONG))) {
                            object3 = fitDataMessageField.asInteger();
                            object2 = this.convertSemicirclesToDegree((Integer)object3);
                            ((FitRecord)object4).posLong = object2;
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_ALTITUDE))) {
                            object3 = fitDataMessageField.asLong().doubleValue();
                            object3 = (Double)object3 / (double)RECORD_ALTITUDE_SCALE.intValue();
                            object3 = (Double)object3 + (double)RECORD_ALTITUDE_OFFSET.intValue();
                            ((FitRecord)object4).altitude = object3;
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_TIMESTAMP))) {
                            object3 = fitDataMessageField.asInteger();
                            object2 = this.convertToJodaTime((Integer)object3);
                            ((FitRecord)object4).timestamp = object2;
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_CADENCE))) {
                            ((FitRecord)object4).cadence = fitDataMessageField.asInteger();
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_HEARTRATE))) {
                            ((FitRecord)object4).heartrate = fitDataMessageField.asInteger();
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_TEMPERATURE))) {
                            ((FitRecord)object4).temperature = fitDataMessageField.asInteger();
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_ENHANCED_SPEED))) {
                            object3 = fitDataMessageField.asInteger();
                            ((FitRecord)object4).enhancedSpeed = object3 = Integer.valueOf((Integer)object3 / RECORD_ENHANCED_SPEED_SCALE);
                        }
                        if (null != (fitDataMessageField = ((FitDataMessage)object).getField(RECORD_FIELD_ZONE))) {
                            ((FitRecord)object4).zone = fitDataMessageField.asInteger();
                        }
                        this.records.add((FitRecord)object4);
                        break;
                    }
                    case 19: {
                        object4 = ((FitDataMessage)object).getField(LAP_FIELD_TIMESTAMP);
                        if (null == object4) continue block7;
                        this.laps.add(new ArrayList<FitRecord>(this.records));
                        this.records.clear();
                        this.lap = this.lap + 1;
                        break;
                    }
                    case 49: {
                        object4 = ((FitDataMessage)object).getField(CREATOR_FIELD_SVERSION);
                        if (null != object4 && !((FitDataMessageField)object4).isInvalid().booleanValue()) {
                            this.creator = this.creator + "." + ((FitDataMessageField)object4).asString();
                        }
                        if (null == (object4 = ((FitDataMessage)object).getField(CREATOR_FIELD_HVERSION)) || ((FitDataMessageField)object4).isInvalid().booleanValue()) break;
                        this.creator = this.creator + "." + ((FitDataMessageField)object4).asString();
                    }
                }
            }
            if (!this.records.isEmpty()) {
                this.laps.add(this.records);
            }
            System.err.println("  Bytes read: " + l);
            if (l != l2) {
                throw new ValidationException("Had to read " + l2 + " bytes, but read only " + l + ". Can not proceed.");
            }
            if (inputStream.available() > 0) {
                object = new FitCrc();
                object.read(inputStream);
                if (crc.getValue() != (long)((FitCrc)((Object)object)).fitCrc.get()) {
                    throw new ValidationException("FIT file CRC mismatch. Expected:" + Integer.toHexString(((FitCrc)((Object)object)).fitCrc.get()) + " but calculated:" + Long.toHexString(crc.getValue()));
                }
            }
        }

        public void generateWaypoints(ArrayList<FitRecord> arrayList, WaypointGroup waypointGroup, GPXFile gPXFile) {
            for (FitRecord fitRecord : arrayList) {
                GPXExtension gPXExtension;
                if (fitRecord.posLat == null || fitRecord.posLong == null) {
                    System.err.println("Record with empty latitude or empty longitude ignored!");
                    continue;
                }
                Waypoint waypoint = new Waypoint(fitRecord.posLat, fitRecord.posLong);
                if (null != fitRecord.timestamp) {
                    waypoint.setTime(fitRecord.timestamp.toDate());
                }
                if (null != fitRecord.altitude) {
                    waypoint.setEle(fitRecord.altitude);
                }
                if (null != fitRecord.cadence) {
                    if (!gPXFile.getExtensionPrefixes().contains("tp1")) {
                        gPXFile.addExtensionPrefix("tp1");
                    }
                    if (null == (gPXExtension = waypoint.getExtension().getExtension("tp1:TrackPointExtension"))) {
                        gPXExtension = new GPXExtension("tp1:TrackPointExtension");
                        gPXExtension.setNamespace("http://www.garmin.com/xmlschemas/TrackPointExtension/v1");
                        waypoint.getExtension().add(gPXExtension);
                    }
                    gPXExtension.add("tp1:cad", fitRecord.cadence.toString());
                }
                if (null != fitRecord.heartrate) {
                    if (!gPXFile.getExtensionPrefixes().contains("tp1")) {
                        gPXFile.addExtensionPrefix("tp1");
                    }
                    if (null == (gPXExtension = waypoint.getExtension().getExtension("tp1:TrackPointExtension"))) {
                        gPXExtension = new GPXExtension("tp1:TrackPointExtension");
                        gPXExtension.setNamespace("http://www.garmin.com/xmlschemas/TrackPointExtension/v1");
                        waypoint.getExtension().add(gPXExtension);
                    }
                    gPXExtension.add("tp1:hr", fitRecord.heartrate.toString());
                }
                if (null != fitRecord.temperature) {
                    if (!gPXFile.getExtensionPrefixes().contains("tp1")) {
                        gPXFile.addExtensionPrefix("tp1");
                    }
                    if (null == (gPXExtension = waypoint.getExtension().getExtension("tp1:TrackPointExtension"))) {
                        gPXExtension = new GPXExtension("tp1:TrackPointExtension");
                        gPXExtension.setNamespace("http://www.garmin.com/xmlschemas/TrackPointExtension/v1");
                        waypoint.getExtension().add(gPXExtension);
                    }
                    gPXExtension.add("tp1:atemp", fitRecord.temperature.toString());
                }
                if (fitRecord.hrv != 0.0) {
                    gPXExtension = new GPXExtension("gpsm:HeartRateVariability", Double.toString(fitRecord.hrv));
                    waypoint.getExtension().add(gPXExtension);
                }
                if (null != fitRecord.enhancedSpeed) {
                    gPXExtension = new GPXExtension("gpsm:Acceleration", fitRecord.enhancedSpeed.toString());
                    waypoint.getExtension().add(gPXExtension);
                }
                if (null != fitRecord.zone) {
                    gPXExtension = new GPXExtension("gpsm:Zone", fitRecord.zone.toString());
                    waypoint.getExtension().add(gPXExtension);
                }
                waypointGroup.addWaypoint(waypoint);
            }
        }

        static class FitRecord {
            public Double posLat;
            public Double posLong;
            public Double altitude;
            public Integer cadence;
            public Integer heartrate;
            public Integer temperature;
            public Integer zone;
            public Integer enhancedSpeed;
            public DateTime timestamp;
            public Double hrv;

            FitRecord() {
            }

            public String toString() {
                String string = "FitRecord:\n  posLat=" + this.posLat + "\n  posLong=" + this.posLong + "\n  altitude=" + this.altitude + "\n  cadence=" + this.cadence + "\n  heartrate=" + this.heartrate + "\n  temperature=" + this.temperature + "\n  zone=" + this.zone + "\n  speed=" + this.enhancedSpeed + "\n  hrv=" + this.hrv + "\n  time=" + this.timestamp;
                return string;
            }
        }

        static class FitDefinitionFieldBaseType
        extends FitStructPacked {
            public final Struct.BitField baseTypeNumber = new Struct.BitField((Struct)this, 5);
            public final Struct.BitField reserved = new Struct.BitField((Struct)this, 2);
            public final Struct.BitField endianess = new Struct.BitField((Struct)this, 1);

            public FitDefinitionFieldBaseType(Boolean bl) {
                super(bl);
            }
        }

        static class FitDefinitionField
        extends FitStructPacked {
            public final Struct.Unsigned8 fieldDefinitionNumber = new Struct.Unsigned8((Struct)this);
            public final Struct.Unsigned8 size = new Struct.Unsigned8((Struct)this);

            public FitDefinitionField(Boolean bl) {
                super(bl);
            }
        }

        static class FitDefinitionMessageContentFixed
        extends FitStructPacked {
            public final Struct.Unsigned16 globalMsgNum = new Struct.Unsigned16((Struct)this);
            public final Struct.Unsigned8 numberOfFields = new Struct.Unsigned8((Struct)this);

            public FitDefinitionMessageContentFixed(Boolean bl) {
                super(bl);
            }
        }

        static class FitCompressedHeader
        extends FitStructPacked {
            public final Struct.BitField timeOffset = new Struct.BitField((Struct)this, 5);
            public final Struct.BitField localMessageType = new Struct.BitField((Struct)this, 2);
            public final Struct.BitField normal = new Struct.BitField((Struct)this, 1);

            FitCompressedHeader() {
            }
        }

        static class FitRecordHeader
        extends FitStructPacked {
            public final Struct.BitField localMessageType = new Struct.BitField((Struct)this, 4);
            public final Struct.BitField reserved2 = new Struct.BitField((Struct)this, 1);
            public final Struct.BitField devDataFlag = new Struct.BitField((Struct)this, 1);
            public final Struct.BitField messageType = new Struct.BitField((Struct)this, 1);
            public final Struct.BitField normal = new Struct.BitField((Struct)this, 1);

            FitRecordHeader() {
            }
        }

        static class FitHeader
        extends FitStructPacked {
            public final Struct.Unsigned8 headerSize = new Struct.Unsigned8((Struct)this);
            public final Struct.Unsigned8 protocolVersion = new Struct.Unsigned8((Struct)this);
            public final Struct.Unsigned16 profileVersion = new Struct.Unsigned16((Struct)this);
            public final Struct.Unsigned32 dataSize = new Struct.Unsigned32((Struct)this);
            public final Struct.Unsigned32 dataType = new Struct.Unsigned32((Struct)this);

            FitHeader() {
            }
        }

        static class FitCrc
        extends FitStructPacked {
            public final Struct.Unsigned16 fitCrc = new Struct.Unsigned16((Struct)this);

            public FitCrc() {
                this.setEndian(true);
            }
        }

        static class FitByte
        extends FitStructPacked {
            public final Struct.Unsigned8 fitByte = new Struct.Unsigned8((Struct)this);

            FitByte() {
            }
        }

        static class FitDataTypes {
            private static final HashMap<Integer, FitBaseType> fitBaseTypeViaNumbers = new HashMap(16);

            private FitDataTypes() {
                FitBaseType fitBaseType = new FitBaseType(0, "enum", false, new Byte[]{(byte)-1}, 1);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(1, "sint8", false, new Byte[]{(byte)127}, 1);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(2, "uint8", false, new Byte[]{(byte)-1}, 1);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(3, "sint16", true, new Byte[]{(byte)127, (byte)-1}, 2);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(4, "uint16", true, new Byte[]{(byte)-1, (byte)-1}, 2);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(5, "sint32", true, new Byte[]{(byte)127, (byte)-1, (byte)-1, (byte)-1}, 4);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(6, "uint32", true, new Byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1}, 4);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(7, "string", false, new Byte[]{(byte)0}, 1);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(8, "float32", true, new Byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1}, 4);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(9, "float64", true, new Byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1}, 8);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(10, "uint8z", false, new Byte[]{(byte)0}, 1);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(11, "uint16z", true, new Byte[]{(byte)0, (byte)0}, 2);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(12, "uint32z", true, new Byte[]{(byte)0, (byte)0, (byte)0, (byte)0}, 4);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(13, "byte", false, new Byte[]{(byte)-1}, 1);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(14, "sint64", true, new Byte[]{(byte)127, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1}, 8);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(15, "uint64", true, new Byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1}, 8);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
                fitBaseType = new FitBaseType(16, "uint64z", true, new Byte[]{(byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0}, 8);
                fitBaseTypeViaNumbers.put(fitBaseType.typeNumber, fitBaseType);
            }

            public static FitBaseType getBaseType(Integer n) {
                return fitBaseTypeViaNumbers.get(n);
            }

            static {
                new FitDataTypes();
            }
        }

        static class FitBaseType {
            public String typeName;
            public Integer typeNumber;
            public Boolean endianAbility = false;
            public Byte[] invalidValue;
            public Integer size;

            public FitBaseType(Integer n, String string, Boolean bl, Byte[] byteArray, Integer n2) {
                this.typeNumber = n;
                this.typeName = string;
                this.endianAbility = bl;
                this.invalidValue = byteArray;
                this.size = n2;
            }
        }

        static class Float64Array
        extends FitStructPacked {
            public final Struct.Float64[] data;

            public Float64Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Float64[])this.array((Struct.Member[])new Struct.Float64[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Float64 float64 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (float64.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Float32Array
        extends FitStructPacked {
            public final Struct.Float32[] data;

            public Float32Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Float32[])this.array((Struct.Member[])new Struct.Float32[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Float32 float32 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (float32.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Signed64Array
        extends FitStructPacked {
            public final Struct.Signed64[] data;

            public Signed64Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Signed64[])this.array((Struct.Member[])new Struct.Signed64[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Signed64 signed64 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (signed64.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Unsigned64Array
        extends FitStructPacked {
            public final Struct.Signed64[] data;

            public Unsigned64Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Signed64[])this.array((Struct.Member[])new Struct.Signed64[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Signed64 signed64 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (signed64.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Signed32Array
        extends FitStructPacked {
            public final Struct.Signed32[] data;

            public Signed32Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Signed32[])this.array((Struct.Member[])new Struct.Signed32[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Signed32 signed32 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (signed32.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Unsigned32Array
        extends FitStructPacked {
            public final Struct.Unsigned32[] data;

            public Unsigned32Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Unsigned32[])this.array((Struct.Member[])new Struct.Unsigned32[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Unsigned32 unsigned32 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (unsigned32.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Signed16Array
        extends FitStructPacked {
            public final Struct.Signed16[] data;

            public Signed16Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Signed16[])this.array((Struct.Member[])new Struct.Signed16[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Signed16 signed16 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (signed16.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Unsigned16Array
        extends FitStructPacked {
            public final Struct.Unsigned16[] data;

            public Unsigned16Array(Integer n, Boolean bl) {
                super(bl);
                this.data = (Struct.Unsigned16[])this.array((Struct.Member[])new Struct.Unsigned16[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Unsigned16 unsigned16 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (unsigned16.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Signed8Array
        extends FitStructPacked {
            public final Struct.Signed8[] data;

            public Signed8Array(Integer n) {
                this.data = (Struct.Signed8[])this.array((Struct.Member[])new Struct.Signed8[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Signed8 signed8 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (signed8.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class Unsigned8Array
        extends FitStructPacked {
            public final Struct.Unsigned8[] data;

            public Unsigned8Array(Integer n) {
                this.data = (Struct.Unsigned8[])this.array((Struct.Member[])new Struct.Unsigned8[n.intValue()]);
            }

            public Boolean isInvalid(Byte[] byteArray) {
                for (Struct.Unsigned8 unsigned8 : this.data) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (unsigned8.struct().getByteBuffer().get(i) == byteArray[i].byteValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        static class StringArray
        extends FitStructPacked {
            public final Struct.UTF8String data;

            public StringArray(Integer n) {
                this.data = new Struct.UTF8String((Struct)this, n.intValue());
            }

            public Boolean isInvalid(Byte[] byteArray) {
                if (this.data.struct().getByteBuffer().get(0) != byteArray[0].byteValue()) {
                    return false;
                }
                return true;
            }
        }

        static class FitStructPacked
        extends Struct {
            private Boolean isLittleEndian = true;

            public FitStructPacked() {
            }

            public FitStructPacked(Boolean bl) {
                this.isLittleEndian = bl;
            }

            public void setEndian(Boolean bl) {
                this.isLittleEndian = bl;
            }

            public ByteOrder byteOrder() {
                if (this.isLittleEndian.booleanValue()) {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                return ByteOrder.BIG_ENDIAN;
            }

            public boolean isPacked() {
                return true;
            }

            public int read(InputStream inputStream, Crc crc) throws IOException {
                int n = super.read(inputStream);
                crc.calculate(this.getByteBuffer());
                return n;
            }
        }

        static class FitDataMessageFieldTypeUnsigned64
        extends FitDataMessageFieldType {
            final Unsigned64Array data;

            public FitDataMessageFieldTypeUnsigned64(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Unsigned64Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Signed64 signed64 : this.data.data) {
                    this.addLong(signed64.get());
                    this.addString(signed64.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "uint64";
            }
        }

        static class FitDataMessageFieldTypeSigned64
        extends FitDataMessageFieldType {
            final Signed64Array data;

            public FitDataMessageFieldTypeSigned64(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Signed64Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Signed64 signed64 : this.data.data) {
                    this.addLong(signed64.get());
                    this.addString(signed64.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "sint64";
            }
        }

        static class FitDataMessageFieldTypeFloat64
        extends FitDataMessageFieldType {
            final Float64Array data;

            public FitDataMessageFieldTypeFloat64(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Float64Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Float64 float64 : this.data.data) {
                    this.addString(float64.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "float64";
            }
        }

        static class FitDataMessageFieldTypeFloat32
        extends FitDataMessageFieldType {
            final Float32Array data;

            public FitDataMessageFieldTypeFloat32(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Float32Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Float32 float32 : this.data.data) {
                    this.addString(float32.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "float32";
            }
        }

        static class FitDataMessageFieldTypeUnsigned32
        extends FitDataMessageFieldType {
            final Unsigned32Array data;

            public FitDataMessageFieldTypeUnsigned32(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Unsigned32Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Unsigned32 unsigned32 : this.data.data) {
                    this.addLong(unsigned32.get());
                    this.addString(unsigned32.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "uint32";
            }
        }

        static class FitDataMessageFieldTypeSigned32
        extends FitDataMessageFieldType {
            final Signed32Array data;

            public FitDataMessageFieldTypeSigned32(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Signed32Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Signed32 signed32 : this.data.data) {
                    this.addLong(Long.valueOf(signed32.get()));
                    this.addString(signed32.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "sint32";
            }
        }

        static class FitDataMessageFieldTypeUnsigned16
        extends FitDataMessageFieldType {
            final Unsigned16Array data;

            public FitDataMessageFieldTypeUnsigned16(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Unsigned16Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Unsigned16 unsigned16 : this.data.data) {
                    this.addLong(Long.valueOf(unsigned16.get()));
                    this.addString(unsigned16.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "uint16";
            }
        }

        static class FitDataMessageFieldTypeSigned16
        extends FitDataMessageFieldType {
            final Signed16Array data;

            public FitDataMessageFieldTypeSigned16(Integer n, Integer n2, Boolean bl, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Signed16Array(n2, bl);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Signed16 signed16 : this.data.data) {
                    this.addLong(Long.valueOf(signed16.get()));
                    this.addString(signed16.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "sint16";
            }
        }

        static class FitDataMessageFieldTypeEnum
        extends FitDataMessageFieldTypeUnsigned8 {
            public FitDataMessageFieldTypeEnum(Integer n, Integer n2, Byte[] byteArray) {
                super(n, n2, byteArray);
            }

            @Override
            public String getTypeName() {
                return "enum";
            }
        }

        static class FitDataMessageFieldTypeUnsigned8
        extends FitDataMessageFieldType {
            final Unsigned8Array data;

            public FitDataMessageFieldTypeUnsigned8(Integer n, Integer n2, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Unsigned8Array(n2);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Unsigned8 unsigned8 : this.data.data) {
                    this.addLong(Long.valueOf(unsigned8.get()));
                    this.addString(unsigned8.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "uint8";
            }
        }

        static class FitDataMessageFieldTypeSigned8
        extends FitDataMessageFieldType {
            final Signed8Array data;

            public FitDataMessageFieldTypeSigned8(Integer n, Integer n2, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new Signed8Array(n2);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                for (Struct.Signed8 signed8 : this.data.data) {
                    this.addLong(Long.valueOf(signed8.get()));
                    this.addString(signed8.toString());
                }
            }

            @Override
            public String getTypeName() {
                return "sint8";
            }
        }

        static class FitDataMessageFieldTypeString
        extends FitDataMessageFieldType {
            final StringArray data;

            public FitDataMessageFieldTypeString(Integer n, Integer n2, Byte[] byteArray) {
                super(n, n2, byteArray);
                this.data = new StringArray(n2);
            }

            @Override
            public void read(InputStream inputStream, Crc crc) throws IOException {
                this.clearForRead();
                this.data.getByteBuffer().clear();
                this.data.read(inputStream, crc);
                this.setInvalid(this.data.isInvalid(this.getInvalidValue()));
                this.addString(this.data.toString());
            }

            @Override
            public String getTypeName() {
                return "String";
            }
        }

        static class FitDataMessageFieldTypeFactory {
            FitDataMessageFieldTypeFactory() {
            }

            public static FitDataMessageFieldType getFieldType(Integer n, Integer n2, Boolean bl, FitBaseType fitBaseType) {
                FitDataMessageFieldType fitDataMessageFieldType = null;
                Integer n3 = n2 / fitBaseType.size;
                if (0 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeEnum(n, n3, fitBaseType.invalidValue);
                }
                if (1 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeSigned8(n, n3, fitBaseType.invalidValue);
                }
                if (2 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned8(n, n3, fitBaseType.invalidValue);
                }
                if (3 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeSigned16(n, n3, bl, fitBaseType.invalidValue);
                }
                if (4 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned16(n, n3, bl, fitBaseType.invalidValue);
                }
                if (5 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeSigned32(n, n3, bl, fitBaseType.invalidValue);
                }
                if (6 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned32(n, n3, bl, fitBaseType.invalidValue);
                }
                if (7 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeString(n, n3, fitBaseType.invalidValue);
                }
                if (8 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeFloat32(n, n3, bl, fitBaseType.invalidValue);
                }
                if (9 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeFloat64(n, n3, bl, fitBaseType.invalidValue);
                }
                if (10 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned8(n, n3, fitBaseType.invalidValue);
                }
                if (11 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned16(n, n3, bl, fitBaseType.invalidValue);
                }
                if (12 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned32(n, n3, bl, fitBaseType.invalidValue);
                }
                if (13 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned8(n, n3, fitBaseType.invalidValue);
                }
                if (14 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeSigned64(n, n3, bl, fitBaseType.invalidValue);
                }
                if (15 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned64(n, n3, bl, fitBaseType.invalidValue);
                }
                if (16 == fitBaseType.typeNumber) {
                    fitDataMessageFieldType = new FitDataMessageFieldTypeUnsigned64(n, n3, bl, fitBaseType.invalidValue);
                }
                return fitDataMessageFieldType;
            }
        }

        static abstract class FitDataMessageFieldType {
            private Integer fieldNumber;
            private ArrayList<String> contentArrayAsString;
            private ArrayList<Long> contentArrayAsLong;
            private Boolean isInvalid;
            private Byte[] invalidValue;

            public abstract void read(InputStream var1, Crc var2) throws IOException;

            public FitDataMessageFieldType(Integer n, Integer n2, Byte[] byteArray) {
                this.fieldNumber = n;
                this.contentArrayAsString = new ArrayList(n2);
                this.contentArrayAsLong = new ArrayList(n2);
                this.invalidValue = byteArray;
            }

            protected void clearForRead() {
                this.contentArrayAsString.clear();
                this.contentArrayAsLong.clear();
                this.isInvalid = false;
            }

            protected void addString(String string) {
                this.contentArrayAsString.add(string);
            }

            protected void addLong(Long l) {
                this.contentArrayAsLong.add(l);
            }

            public Integer getFieldNumber() {
                return this.fieldNumber;
            }

            public Byte[] getInvalidValue() {
                return this.invalidValue;
            }

            public Boolean isInvalid() {
                return this.isInvalid;
            }

            protected void setInvalid(Boolean bl) {
                this.isInvalid = bl;
            }

            public String asString() {
                if (1 == this.contentArrayAsString.size()) {
                    return this.contentArrayAsString.get(0);
                }
                return Arrays.toString(this.contentArrayAsString.toArray());
            }

            public Integer asInteger() {
                return this.contentArrayAsLong.get(0).intValue();
            }

            public Long asLong() {
                return this.contentArrayAsLong.get(0);
            }

            public Iterator<String> iteratorString() {
                return this.contentArrayAsString.iterator();
            }

            public Iterator<Long> iteratorLong() {
                return this.contentArrayAsLong.iterator();
            }

            public abstract String getTypeName();
        }

        static class FitDataMessageField {
            private FitDataMessageFieldType content;
            private Boolean isArray;
            private Integer sizeInBytes;

            public FitDataMessageField(Integer n, Integer n2, Boolean bl, FitBaseType fitBaseType) {
                this.isArray = !fitBaseType.size.equals(n2);
                this.sizeInBytes = n2;
                this.content = FitDataMessageFieldTypeFactory.getFieldType(n, n2, bl, fitBaseType);
            }

            public String asString() {
                return this.content.asString();
            }

            public Integer asInteger() {
                return this.content.asInteger();
            }

            public Long asLong() {
                return this.content.asLong();
            }

            public Iterator<String> iteratorString() {
                return this.content.iteratorString();
            }

            public Iterator<Long> iteratorLong() {
                return this.content.iteratorLong();
            }

            public Boolean isInvalid() {
                return this.content.isInvalid();
            }

            public Boolean isArray() {
                return this.isArray;
            }

            public Integer getFieldNumber() {
                return this.content.getFieldNumber();
            }

            public Integer getSizeInBytes() {
                return this.sizeInBytes;
            }

            public Integer read(InputStream inputStream, Crc crc) throws IOException {
                this.content.read(inputStream, crc);
                return this.sizeInBytes;
            }

            public void injectLong(Long l) {
                this.content.addLong(l);
            }
        }

        static class FitDataMessage {
            private Integer globalMessageNumber;
            private Integer localMessageNumber;
            private ArrayList<FitDataMessageField> fields;
            private HashMap<Integer, FitDataMessageField> mapFields;
            private ArrayList<FitDataMessageField> devFields;
            private HashMap<Integer, FitDataMessageField> mapDevFields;
            private Long lastDateRead = 0L;

            public FitDataMessage(Integer n, Integer n2, Integer n3) {
                this.globalMessageNumber = n;
                this.localMessageNumber = n2;
                this.fields = new ArrayList(n3);
                this.mapFields = new HashMap(n3);
            }

            public Collection<FitDataMessageField> getFields() {
                return this.mapFields.values();
            }

            public void addField(FitDataMessageField fitDataMessageField) {
                this.fields.add(fitDataMessageField);
                this.mapFields.put(fitDataMessageField.getFieldNumber(), fitDataMessageField);
            }

            public FitDataMessageField getField(Integer n) {
                return this.mapFields.get(n);
            }

            public void addDevFields(short s) {
                this.devFields = new ArrayList(s);
                this.mapDevFields = new HashMap(s);
            }

            public void addDevField(FitDataMessageField fitDataMessageField) {
                this.devFields.add(fitDataMessageField);
                this.mapDevFields.put(fitDataMessageField.getFieldNumber(), fitDataMessageField);
            }

            public Collection<FitDataMessageField> getDevFields() {
                return this.mapDevFields.values();
            }

            public Integer read(InputStream inputStream, Boolean bl, Crc crc) throws IOException {
                Integer n = 0;
                for (FitDataMessageField fitDataMessageField : this.fields) {
                    if (fitDataMessageField.getFieldNumber().equals(TIMESTAMP_FIELD) && bl.booleanValue()) {
                        fitDataMessageField.injectLong(this.lastDateRead);
                        System.out.println("Compressed header detected. Field #253 not read but set to last timestamp read.");
                        continue;
                    }
                    n = n + fitDataMessageField.read(inputStream, crc);
                    if (!fitDataMessageField.getFieldNumber().equals(TIMESTAMP_FIELD)) continue;
                    this.lastDateRead = fitDataMessageField.asLong();
                }
                if (null != this.devFields) {
                    for (FitDataMessageField fitDataMessageField : this.devFields) {
                        n = n + fitDataMessageField.read(inputStream, crc);
                    }
                }
                return n;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(1024);
                stringBuilder.append("FitMessage[");
                stringBuilder.append(this.globalMessageNumber);
                stringBuilder.append("][");
                stringBuilder.append(this.localMessageNumber);
                stringBuilder.append("]=\n");
                for (FitDataMessageField fitDataMessageField : this.fields) {
                    if (fitDataMessageField.isInvalid() == null || fitDataMessageField.isInvalid().booleanValue()) {
                        stringBuilder.append("  ! ");
                    } else {
                        stringBuilder.append("    ");
                    }
                    stringBuilder.append(fitDataMessageField.getFieldNumber());
                    stringBuilder.append("[");
                    stringBuilder.append(fitDataMessageField.content.getTypeName());
                    if (fitDataMessageField.isArray().booleanValue()) {
                        stringBuilder.append("[");
                        stringBuilder.append(fitDataMessageField.getSizeInBytes() / fitDataMessageField.content.getInvalidValue().length);
                        stringBuilder.append("]");
                    }
                    stringBuilder.append("]");
                    stringBuilder.append("=");
                    stringBuilder.append(fitDataMessageField.asString());
                    stringBuilder.append("\n");
                }
                if (null != this.devFields) {
                    for (FitDataMessageField fitDataMessageField : this.devFields) {
                        if (fitDataMessageField.isInvalid() == null || fitDataMessageField.isInvalid().booleanValue()) {
                            stringBuilder.append("  ! ");
                        } else {
                            stringBuilder.append("    ");
                        }
                        stringBuilder.append(fitDataMessageField.getFieldNumber());
                        stringBuilder.append("[");
                        stringBuilder.append(fitDataMessageField.content.getTypeName());
                        stringBuilder.append("]");
                        stringBuilder.append("=");
                        stringBuilder.append(fitDataMessageField.asString());
                        stringBuilder.append("\n");
                    }
                }
                return stringBuilder.toString();
            }
        }

        static final class Crc {
            private static final int[] crc_table = new int[]{0, 52225, 55297, 5120, 61441, 15360, 10240, 58369, 40961, 27648, 30720, 46081, 20480, 39937, 34817, 17408};
            private int crc;

            public Crc() {
                this.reset();
            }

            public long getValue() {
                return this.crc;
            }

            public void reset() {
                this.crc = 0;
            }

            public void calculate(byte by) {
                int n = crc_table[this.crc & 0xF];
                this.crc = this.crc >> 4 & 0xFFF;
                this.crc = this.crc ^ n ^ crc_table[by & 0xF];
                n = crc_table[this.crc & 0xF];
                this.crc = this.crc >> 4 & 0xFFF;
                this.crc = this.crc ^ n ^ crc_table[by >> 4 & 0xF];
            }

            public void calculate(ByteBuffer byteBuffer) {
                for (int i = 0; i < byteBuffer.capacity(); ++i) {
                    byte by = byteBuffer.get(i);
                    this.calculate(by);
                }
            }

            public void calculate(byte[] byArray) {
                for (byte by : byArray) {
                    this.calculate(by);
                }
            }
        }
    }
}

