/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.util.ArrayList;
import java.util.List;
import org.gpsmaster.gpsloader.CpoLoader;
import org.gpsmaster.gpsloader.CsvLoader;
import org.gpsmaster.gpsloader.FitLoader;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpsloader.GpxLoader;
import org.gpsmaster.gpsloader.IgcLoader;
import org.gpsmaster.gpsloader.KmlLoader;
import org.gpsmaster.gpsloader.NmeaLoader;
import org.gpsmaster.gpsloader.TcxLoader;

public class GpsLoaderFactory {
    List<String> extensions = new ArrayList<String>();
    static final List<GpsLoader> loaders = new ArrayList<GpsLoader>();

    public GpsLoaderFactory() {
        loaders.clear();
        loaders.add(new GpxLoader());
        loaders.add(new KmlLoader());
        loaders.add(new IgcLoader());
        loaders.add(new NmeaLoader());
        loaders.add(new CpoLoader());
        loaders.add(new TcxLoader());
        loaders.add(new FitLoader());
        loaders.add(new CsvLoader());
    }

    public List<String> getExtensions() {
        this.getExtensionList();
        return this.extensions;
    }

    public static GpsLoader getLoaderByExtension(String string) throws ClassNotFoundException {
        for (GpsLoader gpsLoader : loaders) {
            if (gpsLoader.getLoadFormats().contains(string.toLowerCase())) {
                return gpsLoader;
            }
            if (!gpsLoader.getLoadFormats().contains(string.toUpperCase())) continue;
            return gpsLoader;
        }
        throw new ClassNotFoundException(string);
    }

    public static GpsLoader getLoaderByClassName(String string) throws ClassNotFoundException {
        for (GpsLoader gpsLoader : loaders) {
            if (!gpsLoader.getClass().getName().equals(string)) continue;
            return gpsLoader;
        }
        throw new ClassNotFoundException(string);
    }

    private void getExtensionList() {
        this.extensions.clear();
        for (GpsLoader gpsLoader : loaders) {
            this.extensions.addAll(gpsLoader.getLoadFormats());
        }
    }
}

