/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpsloader.IgcExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class IgcLoader
extends GpsLoader {
    private GPXFile gpx = null;
    private Waypoint wpt = null;
    private WaypointGroup trackpoints = null;
    private Route route = null;
    private List<IgcExtension> bExtensions = new ArrayList<IgcExtension>();
    private List<IgcExtension> kExtensions = new ArrayList<IgcExtension>();
    private List<Waypoint> events = new ArrayList<Waypoint>();
    private final SimpleDateFormat utcFormatter = new SimpleDateFormat("ddMMYY HHmmssZ");
    private List<String> wgsDatum = new ArrayList<String>();
    private final String cIgnore = "C0000000N00000000E";
    private String utcDate = "010170";
    private String pilot1 = "";
    private String pilot2 = "";
    private String glider = "";
    private String gliderId = "";

    public IgcLoader() {
        this.isAdding = false;
        this.extensions.add("igc");
        this.wgsDatum.add("WGS84");
        this.wgsDatum.add("WGS1984");
        this.wgsDatum.add("WGS-1984");
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        String string2;
        this.gpx = new GPXFile();
        Track track = new Track(this.gpx.getColor());
        this.trackpoints = track.addTrackseg();
        this.gpx.addTrack(track);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            char c = string2.charAt(0);
            switch (c) {
                case 'A': {
                    this.parseA(string2);
                    break;
                }
                case 'B': {
                    this.parseB(string2);
                    break;
                }
                case 'C': {
                    this.parseC(string2);
                    break;
                }
                case 'E': {
                    this.parseE(string2);
                    break;
                }
                case 'H': {
                    this.parseH(string2);
                    break;
                }
                case 'I': {
                    this.parseIJ(string2, this.bExtensions);
                    break;
                }
                case 'J': {
                    this.parseIJ(string2, this.kExtensions);
                    break;
                }
                case 'K': {
                    this.parseK(string2);
                    break;
                }
                case 'L': {
                    this.parseL(string2);
                    break;
                }
            }
        }
        bufferedReader.close();
        String string3 = "";
        if (!this.glider.isEmpty()) {
            string3 = this.glider;
        }
        if (!this.gliderId.isEmpty()) {
            string3 = !string3.isEmpty() ? string3 + " (" + this.gliderId + ")" : this.gliderId;
        }
        if (!this.pilot1.isEmpty()) {
            string3 = !string3.isEmpty() ? string3 + " piloted by " : "Pilot(s): ";
            string3 = string3 + this.pilot1;
        }
        if (!this.pilot2.isEmpty()) {
            string3 = string3 + ", " + this.pilot2;
        }
        this.gpx.setDesc(string3);
        return this.gpx;
    }

    private String getAfter(String string, String string2) {
        return string.substring(string.indexOf(string2) + 1).trim();
    }

    private void parseA(String string) {
        String string2 = string.substring(1, 3);
        String string3 = string.substring(4, 6);
        String string4 = string.substring(7);
        this.gpx.setCreator(string2 + " (serial #" + string3 + ") " + string4);
    }

    private void parseB(String string) throws ParseException {
        String string2 = string.substring(7, 15);
        String string3 = string.substring(15, 24);
        char c = string.charAt(24);
        String string4 = string.substring(25, 30);
        String string5 = string.substring(30, 35);
        double d = this.parseLat(string2);
        double d2 = this.parseLon(string3);
        this.wpt = new Waypoint(d, d2);
        switch (c) {
            case 'A': {
                this.wpt.setEle(Double.parseDouble(string5));
                break;
            }
            case 'V': {
                this.wpt.setEle(Double.parseDouble(string4));
            }
        }
        if (this.events.size() > 0) {
            for (Waypoint object : this.events) {
                object.setLat(d);
                object.setLon(d2);
                object.setEle(this.wpt.getEle());
                this.gpx.getWaypointGroup().addWaypoint(object);
            }
            this.events.clear();
        }
        this.wpt.setTime(this.parseDate(string.substring(1, 7)));
        for (IgcExtension igcExtension : this.bExtensions) {
            String string6 = igcExtension.getCode();
            String string7 = string.substring(igcExtension.getStart(), igcExtension.getEnd());
            this.wpt.getExtension().add(string6, string7);
        }
        this.trackpoints.addWaypoint(this.wpt);
    }

    private void parseC(String string) {
        if (this.route == null) {
            this.route = new Route(this.gpx.getColor());
            String string2 = string.substring(1, 7) + " " + string.substring(7, 13) + "-0000";
            this.route.setCmt("defined at " + string2 + " UTC");
            String string3 = string.substring(13, 19);
            int n = Integer.parseInt(string.substring(19, 23));
            String string4 = string.substring(25);
            this.route.setName(string3 + " " + string4);
            this.route.setNumber(n);
            this.gpx.getRoutes().add(this.route);
        } else if (!string.equals("C0000000N00000000E")) {
            double d = this.parseLat(string.substring(1, 9));
            double d2 = this.parseLon(string.substring(9, 18));
            String string5 = string.substring(18);
            Waypoint waypoint = new Waypoint(d, d2);
            waypoint.setName(string5);
            this.route.getPath().addWaypoint(waypoint);
        }
    }

    private void parseE(String string) throws ParseException {
        Waypoint waypoint = new Waypoint(0.0, 0.0);
        waypoint.setTime(this.utcFormatter.parse(string.substring(1, 7)));
        waypoint.setType("IGC:Event");
        waypoint.setName(string.substring(8, 11));
        waypoint.setCmt(string.substring(12));
        this.events.add(waypoint);
    }

    private void parseK(String string) {
        if (this.wpt != null) {
            for (IgcExtension igcExtension : this.kExtensions) {
                String string2 = igcExtension.getCode();
                String string3 = string.substring(igcExtension.getStart(), igcExtension.getEnd());
                this.wpt.getExtension().add(string2, string3);
            }
        }
    }

    private void parseL(String string) {
        System.out.println(string);
    }

    private void parseH(String string) {
        String string2;
        if (string.startsWith("HFDTE")) {
            this.utcDate = string.substring(5);
        } else if (string.startsWith("HFPLT")) {
            this.pilot1 = this.getAfter(string, ":");
        } else if (string.startsWith("HFCM2")) {
            this.pilot2 = this.getAfter(string, ":");
        } else if (string.startsWith("HFGTY")) {
            this.glider = this.getAfter(string, ":");
        } else if (string.startsWith("HFGID")) {
            this.gliderId = this.getAfter(string, ":");
        } else if (string.startsWith("HFFTY")) {
            this.gpx.setCreator(this.getAfter(string, ":"));
        } else if (string.startsWith("HFDTM") && !this.wgsDatum.contains(string2 = this.getAfter(string, ":"))) {
            throw new IllegalArgumentException("Unsupported GPS datum " + string2);
        }
    }

    private void parseIJ(String string, List<IgcExtension> list) {
        int n = Integer.parseInt(string.substring(1, 3));
        int n2 = 3;
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(n2, n2 + 7);
            IgcExtension igcExtension = new IgcExtension(string2);
            list.add(igcExtension);
            n2 += 7;
        }
    }

    private double parseLat(String string) {
        int n = Integer.parseInt(string.substring(0, 2));
        double d = (double)Integer.parseInt(string.substring(2, 7)) / 1000.0;
        double d2 = (double)n + d / 60.0;
        if (string.endsWith("S")) {
            d2 *= -1.0;
        }
        return d2;
    }

    private double parseLon(String string) {
        int n = Integer.parseInt(string.substring(0, 3));
        double d = (double)Integer.parseInt(string.substring(3, 8)) / 1000.0;
        double d2 = (double)n + d / 60.0;
        if (string.endsWith("W")) {
            d2 *= -1.0;
        }
        return d2;
    }

    private Date parseDate(String string) throws ParseException {
        String string2 = this.utcDate + " " + string + "-0000";
        return this.utcFormatter.parse(string2);
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
    }

    @Override
    public boolean canValidate() {
        return false;
    }

    @Override
    public void validate(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        super.clear();
        this.events.clear();
        this.route = null;
        this.bExtensions.clear();
    }
}

