/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.swing.tree.TreeNode;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.WaypointGroup;

public abstract class GPXObject
implements TreeNode {
    protected boolean visible = true;
    protected boolean trackPtsVisible = false;
    protected Color color = Color.white;
    protected GPXExtension extension = null;
    private static Color[] colors = new Color[]{new Color(247, 186, 11), new Color(212, 101, 47), new Color(160, 33, 40), new Color(144, 70, 132), new Color(21, 72, 137), new Color(15, 133, 88), new Color(158, 160, 161), new Color(123, 81, 65), new Color(244, 248, 244), new Color(240, 202, 0), new Color(225, 85, 1), new Color(193, 18, 28), new Color(153, 37, 114), new Color(14, 81, 141), new Color(0, 135, 84), new Color(143, 150, 149), new Color(78, 84, 81), new Color(247, 251, 245)};
    private static int currentColor = 0;
    protected double minLat;
    protected double minLon;
    protected double maxLat;
    protected double maxLon;
    protected long duration;
    protected long exStop;
    protected double lengthMeters;
    protected double maxSpeedMps;
    protected double eleStartMeters;
    protected double eleEndMeters;
    protected double eleMinMeters;
    protected double eleMaxMeters;
    protected double grossRiseMeters;
    protected double grossFallMeters;
    protected long riseTime;
    protected long fallTime;
    protected Date startTime;
    protected Date endTime;
    protected HashMap<String, ExtensionMeta> minMaxExtensions;
    protected GPXObject parent = null;

    public abstract void updateAllProperties();

    public GPXObject() {
        this.visible = true;
        this.trackPtsVisible = true;
        this.color = Color.white;
        this.minLat = 86.0;
        this.maxLat = -86.0;
        this.minLon = 180.0;
        this.maxLon = -180.0;
        this.startTime = null;
        this.endTime = null;
        this.extension = new GPXExtension("extensions");
        this.minMaxExtensions = new HashMap(256);
    }

    public GPXObject(boolean bl) {
        this();
        if (bl) {
            this.color = colors[currentColor++ % colors.length];
            this.colorToExt();
        }
    }

    public GPXObject(Color color) {
        this();
        this.color = color;
        this.colorToExt();
    }

    public GPXObject(GPXObject gPXObject) {
        this.color = gPXObject.color;
        this.visible = gPXObject.visible;
        this.trackPtsVisible = gPXObject.trackPtsVisible;
        this.extension = new GPXExtension(gPXObject.extension);
        this.minMaxExtensions = new HashMap<String, ExtensionMeta>(gPXObject.getMinMaxExtensions());
    }

    public abstract void setName(String var1);

    public abstract String getName();

    public abstract void setDesc(String var1);

    public abstract String getDesc();

    public GPXExtension getExtension() {
        return this.extension;
    }

    public void setExtension(GPXExtension gPXExtension) {
        this.extension = gPXExtension;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isTrackPtsVisible() {
        if (this.parent != null) {
            return this.trackPtsVisible && this.parent.isTrackPtsVisible();
        }
        return this.trackPtsVisible;
    }

    public void setTrackPtsVisible(boolean bl) {
        this.trackPtsVisible = bl;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(int n) {
        return colors[n % colors.length];
    }

    public void setColor(Color color) {
        this.color = color;
        this.colorToExt();
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDurationExStop() {
        return this.exStop;
    }

    public double getLengthMeters() {
        return this.lengthMeters;
    }

    public double getMaxSpeedMps() {
        return this.maxSpeedMps;
    }

    public double getEleStartMeters() {
        return this.eleStartMeters;
    }

    public double getEleEndMeters() {
        return this.eleEndMeters;
    }

    public double getEleMinMeters() {
        return this.eleMinMeters;
    }

    public double getEleMaxMeters() {
        return this.eleMaxMeters;
    }

    public double getGrossRiseMeters() {
        return this.grossRiseMeters;
    }

    public double getGrossFallMeters() {
        return this.grossFallMeters;
    }

    public long getRiseTime() {
        return this.riseTime;
    }

    public long getFallTime() {
        return this.fallTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public HashMap<String, ExtensionMeta> getMinMaxExtensions() {
        return this.minMaxExtensions;
    }

    protected void setParent(GPXObject gPXObject) {
        this.parent = gPXObject;
    }

    @Override
    public GPXObject getParent() {
        return this.parent;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isGPXFile() {
        return this.getClass().equals(GPXFile.class);
    }

    public boolean isGPXFileWithOneRoute() {
        return this.isGPXFile() && ((GPXFile)this).getRoutes().size() == 1;
    }

    public boolean isGPXFileWithOneRouteOnly() {
        return this.isGPXFile() && ((GPXFile)this).getRoutes().size() == 1 && ((GPXFile)this).getTracks().size() == 0;
    }

    public boolean isGPXFileWithNoRoutes() {
        return this.isGPXFile() && ((GPXFile)this).getRoutes().size() == 0;
    }

    public boolean isGPXFileWithOneTrackseg() {
        return this.isGPXFile() && ((GPXFile)this).getTracks().size() == 1 && ((GPXFile)this).getTracks().get(0).getTracksegs().size() == 1;
    }

    public boolean isGPXFileWithOneTracksegOnly() {
        return this.isGPXFile() && ((GPXFile)this).getTracks().size() == 1 && ((GPXFile)this).getTracks().get(0).getTracksegs().size() == 1 && ((GPXFile)this).getRoutes().size() == 0;
    }

    public boolean isGPXFileWithTracksegs() {
        return this.isGPXFile() && ((GPXFile)this).getTracks().size() > 0 && ((GPXFile)this).getTracks().get(0).getTracksegs().size() > 0;
    }

    public boolean isWaypoints() {
        return this.isWaypointGroup() && ((WaypointGroup)this).getWptGrpType() == WaypointGroup.WptGrpType.WAYPOINTS;
    }

    public boolean isRoute() {
        return this.getClass().equals(Route.class);
    }

    public boolean isTrack() {
        return this.getClass().equals(Track.class);
    }

    public boolean isTrackWithOneSeg() {
        return this.isTrack() && ((Track)this).getTracksegs().size() == 1;
    }

    public boolean isTrackseg() {
        return this.isWaypointGroup() && ((WaypointGroup)this).getWptGrpType() == WaypointGroup.WptGrpType.TRACKSEG;
    }

    public boolean isWaypointGroup() {
        return this.getClass().equals(WaypointGroup.class);
    }

    private void colorToExt() {
        if (this.extension.containsKey("gpsm:color")) {
            this.extension.remove("gpsm:color");
        }
        String string = String.format("%02x%02x%02x%02x", this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        this.extension.add("gpsm:color", string);
    }

    protected void extToColor() {
        if (this.extension.containsKey("gpsm:color")) {
            String string = this.extension.getSubValue("gpsm:color");
            try {
                int n = Integer.parseInt(string.substring(0, 2), 16);
                int n2 = Integer.parseInt(string.substring(2, 4), 16);
                int n3 = Integer.parseInt(string.substring(4, 6), 16);
                int n4 = Integer.parseInt(string.substring(6, 8), 16);
                this.color = new Color(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                this.color = Color.WHITE;
            }
        }
    }

    public static class ExtensionMeta {
        public String name;
        public ArrayList<Double> values = new ArrayList();
        private boolean sorted = false;

        private void sort() {
            if (!this.sorted) {
                Collections.sort(this.values);
                this.sorted = true;
            }
        }

        public double getMin() {
            this.sort();
            if (0 < this.values.size()) {
                return this.values.get(0);
            }
            return 0.0;
        }

        public double getMax() {
            this.sort();
            if (0 < this.values.size()) {
                return this.values.get(this.values.size() - 1);
            }
            return 0.0;
        }

        double getSum() {
            if (0 < this.values.size()) {
                double d = 0.0;
                for (Double d2 : this.values) {
                    d += d2.doubleValue();
                }
                return d;
            }
            return 0.0;
        }

        public double getMean() {
            if (0 < this.values.size()) {
                return this.getSum() / ((double)this.values.size() * 1.0);
            }
            return 0.0;
        }

        public double getMedian() {
            this.sort();
            if (0 < this.values.size()) {
                int n = this.values.size() / 2;
                if (this.values.size() % 2 == 1) {
                    return this.values.get(n);
                }
                return (this.values.get(n - 1) + this.values.get(n)) / 2.0;
            }
            return 0.0;
        }

        public double getStandardDeviation() {
            double d = 0.0;
            double d2 = this.getMean();
            for (Double d3 : this.values) {
                d += Math.pow(d3 - d2, 2.0);
            }
            if (this.values.size() > 1000) {
                return Math.sqrt(d / (double)this.values.size());
            }
            return Math.sqrt(d / (double)(this.values.size() - 1));
        }
    }
}

