/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import eu.fuegenstein.unit.UnitConverter;
import eu.fuegenstein.util.XTime;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.gpsmaster.gpxpanel.ArrowType;
import org.gpsmaster.gpxpanel.ProgressType;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class LabelPainter {
    private JMapViewer mapViewer = null;
    private UnitConverter uc = null;
    private Polygon arrowHead = new Polygon();
    private Polygon parallelArrow = new Polygon();
    private ArrowType arrowType = ArrowType.NONE;
    private ProgressType progressType = ProgressType.NONE;
    private double multiplier = 2.7f;
    private double minLabelDist = 0.0;
    private double arrowOffset = -12.0;

    public LabelPainter(JMapViewer jMapViewer, UnitConverter unitConverter) {
        this.mapViewer = jMapViewer;
        this.uc = unitConverter;
        this.arrowHead.addPoint(0, 8);
        this.arrowHead.addPoint(-5, -5);
        this.arrowHead.addPoint(5, -5);
        this.parallelArrow.addPoint(0, -14);
        this.parallelArrow.addPoint(0, 8);
        this.parallelArrow.addPoint(-4, -4);
        this.parallelArrow.addPoint(4, -4);
        this.parallelArrow.addPoint(0, 8);
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(ArrowType arrowType) {
        this.arrowType = arrowType;
    }

    public ProgressType getProgressType() {
        return this.progressType;
    }

    public void setProgressType(ProgressType progressType) {
        this.progressType = progressType;
    }

    public Polygon getArrowHead() {
        return this.arrowHead;
    }

    public void setArrowHead(Polygon polygon) {
        this.arrowHead = polygon;
    }

    private void paintParallelArrow(Graphics2D graphics2D, Color color, Waypoint waypoint, Waypoint waypoint2) {
        Point point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
        Point point2 = this.mapViewer.getMapPosition(waypoint2.getLat(), waypoint2.getLon(), false);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.setToIdentity();
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        affineTransform2.translate(point2.x, point2.y);
        affineTransform2.rotate(d - 1.5707963267948966);
        affineTransform2.translate(this.arrowOffset, -0.5 * point.distance(point2));
        graphics2D.setColor(color);
        graphics2D.transform(affineTransform2);
        graphics2D.drawPolygon(this.parallelArrow);
        graphics2D.setTransform(affineTransform);
    }

    private void paintTrackArrow(Graphics2D graphics2D, Color color, Waypoint waypoint, Waypoint waypoint2) {
        Point point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
        Point point2 = this.mapViewer.getMapPosition(waypoint2.getLat(), waypoint2.getLon(), false);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.setToIdentity();
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        affineTransform2.translate(point2.x, point2.y);
        affineTransform2.rotate(d - 1.5707963267948966);
        affineTransform2.translate(0.0, -0.5 * point.distance(point2));
        graphics2D.setColor(color);
        graphics2D.transform(affineTransform2);
        graphics2D.fill(this.arrowHead);
        graphics2D.setTransform(affineTransform);
    }

    private void paintLabel(Graphics2D graphics2D, Waypoint waypoint, Waypoint waypoint2, double d) {
        String string = "";
        Point point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
        switch (this.progressType) {
            case ABSOLUTE: {
                if (waypoint.getTime() == null) {
                    string = "--:--:--";
                    break;
                }
                string = String.format("%tT", waypoint.getTime());
                break;
            }
            case RELATIVE: {
                long l = waypoint2.getDuration(waypoint);
                string = XTime.getDurationString(l);
                break;
            }
        }
        String string2 = this.uc.dist(d, "%.2f");
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = null;
        rectangle2D = string.length() > string2.length() ? fontMetrics.getStringBounds(string, graphics2D) : fontMetrics.getStringBounds(string2, graphics2D);
        graphics2D.setColor(new Color(255, 255, 255, 155));
        graphics2D.fillRoundRect(point.x - 3, point.y - (int)rectangle2D.getHeight() - 3, (int)rectangle2D.getWidth() + 6, (int)(rectangle2D.getHeight() + 4.0) * 2 - 1, 5, 5);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, point.x, point.y - 1);
        graphics2D.drawString(string2, point.x, point.y + (int)rectangle2D.getHeight());
        this.minLabelDist = this.mapViewer.getMeterPerPixel() * (double)((int)rectangle2D.getWidth() + 6) * this.multiplier;
    }

    private void doPaint(Graphics2D graphics2D, WaypointGroup waypointGroup) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        graphics2D.setColor(Color.BLACK);
        Waypoint waypoint = waypointGroup.getStart();
        double d4 = this.minLabelDist / 2.0;
        if (this.progressType != ProgressType.NONE) {
            this.paintLabel(graphics2D, waypointGroup.getStart(), waypointGroup.getStart(), d);
        }
        for (Waypoint waypoint2 : waypointGroup.getWaypoints()) {
            double d5;
            if (d2 >= this.minLabelDist && this.progressType != ProgressType.NONE) {
                this.paintLabel(graphics2D, waypoint2, waypointGroup.getStart(), d);
                d2 = 0.0;
            }
            if (d3 >= d4 && this.arrowType != ArrowType.NONE) {
                switch (this.arrowType) {
                    case ONTRACK: {
                        this.paintTrackArrow(graphics2D, Color.BLACK, waypoint, waypoint2);
                        break;
                    }
                    case PARALLEL: {
                        this.paintParallelArrow(graphics2D, waypointGroup.getColor(), waypoint, waypoint2);
                        break;
                    }
                }
                d3 = 0.0;
                d4 = this.minLabelDist * 2.0;
            }
            if (!Double.isNaN(d5 = waypoint2.getDistance(waypoint))) {
                d += d5;
                d2 += d5;
                d3 += d5;
            }
            waypoint = waypoint2;
        }
        if (this.progressType != ProgressType.NONE) {
            this.paintLabel(graphics2D, waypointGroup.getEnd(), waypointGroup.getStart(), d);
        }
    }

    public void paint(Graphics2D graphics2D, WaypointGroup waypointGroup) {
        if (waypointGroup.getNumPts() > 1 && (this.progressType != ProgressType.NONE || this.arrowType != ArrowType.NONE)) {
            this.minLabelDist = this.mapViewer.getMeterPerPixel() * 50.0 * this.multiplier;
            this.doPaint(graphics2D, waypointGroup);
        }
    }
}

