/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlElement;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GPXObjectCommon;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class Track
extends GPXObjectCommon
implements Comparable<Track> {
    private List<WaypointGroup> tracksegs = new ArrayList<WaypointGroup>();

    public Track(Color color) {
        super(color);
    }

    public Track(Track track) {
        super(track);
        for (WaypointGroup waypointGroup : track.tracksegs) {
            this.tracksegs.add(new WaypointGroup(waypointGroup));
        }
    }

    @Override
    public String toString() {
        String string = "Track";
        if (this.name != null && !this.name.equals("")) {
            string = string.concat(" - " + this.name);
        }
        return string;
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        for (WaypointGroup waypointGroup : this.tracksegs) {
            waypointGroup.setColor(color);
        }
    }

    @XmlElement(name="trkseg")
    public List<WaypointGroup> getTracksegs() {
        return this.tracksegs;
    }

    public WaypointGroup addTrackseg() {
        WaypointGroup waypointGroup = new WaypointGroup(this.color, WaypointGroup.WptGrpType.TRACKSEG);
        waypointGroup.setParent(this);
        this.tracksegs.add(waypointGroup);
        return waypointGroup;
    }

    public WaypointGroup addTrackseg(WaypointGroup waypointGroup) {
        waypointGroup.setParent(this);
        this.tracksegs.add(waypointGroup);
        return waypointGroup;
    }

    public long getNumPts() {
        long l = 0L;
        for (WaypointGroup waypointGroup : this.tracksegs) {
            l += (long)waypointGroup.getNumPts();
        }
        return l;
    }

    @Override
    public void updateAllProperties() {
        this.lengthMeters = 0.0;
        this.maxSpeedMps = 0.0;
        this.duration = 0L;
        this.eleMinMeters = 2.147483647E9;
        this.eleMaxMeters = -2.147483648E9;
        this.riseTime = 0L;
        this.fallTime = 0L;
        this.grossRiseMeters = 0.0;
        this.grossFallMeters = 0.0;
        this.minLat = 86.0;
        this.maxLat = -86.0;
        this.minLon = 180.0;
        this.maxLon = -180.0;
        for (WaypointGroup waypointGroup : this.tracksegs) {
            waypointGroup.updateAllProperties();
            this.duration += waypointGroup.getDuration();
            this.exStop += waypointGroup.getDurationExStop();
            this.maxSpeedMps = Math.max(this.maxSpeedMps, waypointGroup.getMaxSpeedMps());
            this.lengthMeters += waypointGroup.getLengthMeters();
            this.eleMinMeters = Math.min(this.eleMinMeters, waypointGroup.getEleMinMeters());
            this.eleMaxMeters = Math.max(this.eleMaxMeters, waypointGroup.getEleMaxMeters());
            this.grossRiseMeters += waypointGroup.getGrossRiseMeters();
            this.grossFallMeters += waypointGroup.getGrossFallMeters();
            this.riseTime += waypointGroup.getRiseTime();
            this.fallTime += waypointGroup.getFallTime();
            this.minLat = Math.min(this.minLat, waypointGroup.getMinLat());
            this.minLon = Math.min(this.minLon, waypointGroup.getMinLon());
            this.maxLat = Math.max(this.maxLat, waypointGroup.getMaxLat());
            this.maxLon = Math.max(this.maxLon, waypointGroup.getMaxLon());
            if (0 == waypointGroup.minMaxExtensions.size()) continue;
            for (String string : waypointGroup.getMinMaxExtensions().keySet()) {
                GPXObject.ExtensionMeta extensionMeta = waypointGroup.getMinMaxExtensions().get(string);
                GPXObject.ExtensionMeta extensionMeta2 = (GPXObject.ExtensionMeta)this.minMaxExtensions.get(string);
                if (null == extensionMeta2) {
                    extensionMeta2 = new GPXObject.ExtensionMeta();
                    extensionMeta2.name = string;
                    this.minMaxExtensions.put(string, extensionMeta2);
                }
                extensionMeta2.values.addAll(extensionMeta.values);
            }
        }
        if (this.tracksegs.size() > 0) {
            this.eleStartMeters = this.tracksegs.get(0).getEleStartMeters();
            this.eleEndMeters = this.tracksegs.get(this.tracksegs.size() - 1).getEleEndMeters();
            this.startTime = this.tracksegs.get(0).getStartTime();
            this.endTime = this.tracksegs.get(this.tracksegs.size() - 1).getEndTime();
        } else {
            this.eleStartMeters = 0.0;
            this.eleEndMeters = 0.0;
        }
        this.extToColor();
    }

    @Override
    public int compareTo(Track track) {
        if (this.getStartTime() == null || track.getStartTime() == null) {
            return 0;
        }
        return this.getStartTime().compareTo(track.getStartTime());
    }

    public Enumeration<WaypointGroup> children() {
        return Collections.enumeration(this.tracksegs);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.tracksegs.get(n);
    }

    @Override
    public int getChildCount() {
        return this.tracksegs.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.tracksegs.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.tracksegs.size() == 0;
    }
}

