/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import com.topografix.gpx._1._1.LinkType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public class Waypoint
implements Comparable<Waypoint> {
    private double lat;
    private double lon;
    private double ele;
    private double hdop;
    private double vdop;
    private double pdop;
    private double magvar;
    private double geoidheight;
    private double ageofdgpsdata;
    private int sat = 0;
    private int dgpsid = 0;
    private Date time = null;
    protected String name = "";
    protected String desc = "";
    protected String type = "";
    protected String cmt = "";
    protected String sym = "";
    protected String src = "";
    protected String fix = "";
    protected Color segmentColor = null;
    protected ArrayList<LinkType> links = null;
    private GPXExtension extension = null;

    public Waypoint(double d, double d2) {
        this.lat = d;
        this.lon = d2;
        this.time = null;
    }

    public Waypoint(Waypoint waypoint) {
        this.lat = waypoint.lat;
        this.lon = waypoint.lon;
        this.ele = waypoint.ele;
        this.hdop = waypoint.hdop;
        this.vdop = waypoint.vdop;
        this.pdop = waypoint.pdop;
        this.sat = waypoint.sat;
        this.time = waypoint.time;
        this.name = waypoint.name;
        this.desc = waypoint.desc;
        this.type = waypoint.type;
        if (waypoint.extension != null) {
            this.extension = new GPXExtension(waypoint.extension);
        }
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double d) {
        this.lat = d;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double d) {
        this.lon = d;
    }

    public double getEle() {
        return this.ele;
    }

    public void setEle(double d) {
        this.ele = d;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date date) {
        this.time = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public String getCmt() {
        return this.cmt;
    }

    public void setCmt(String string) {
        this.cmt = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String string) {
        this.src = string;
    }

    public List<LinkType> getLink() {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        return this.links;
    }

    public String getSym() {
        return this.sym;
    }

    public void setSym(String string) {
        this.sym = string;
    }

    public double getHdop() {
        return this.hdop;
    }

    public void setHdop(double d) {
        this.hdop = d;
    }

    public double getVdop() {
        return this.vdop;
    }

    public void setVdop(double d) {
        this.vdop = d;
    }

    public double getPdop() {
        return this.pdop;
    }

    public void setPdop(double d) {
        this.pdop = d;
    }

    public int getSat() {
        return this.sat;
    }

    public void setSat(int n) {
        this.sat = n;
    }

    public double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(double d) {
        this.magvar = d;
    }

    public double getGeoidheight() {
        return this.geoidheight;
    }

    public void setGeoidheight(double d) {
        this.geoidheight = d;
    }

    public String getFix() {
        return this.fix;
    }

    public void setFix(String string) {
        this.fix = string;
    }

    public double getAgeofdgpsdata() {
        return this.ageofdgpsdata;
    }

    public void setAgeofdgpsdata(double d) {
        this.ageofdgpsdata = d;
    }

    public int getDgpsid() {
        return this.dgpsid;
    }

    public void setDgpsid(int n) {
        this.dgpsid = n;
    }

    public Color getSegmentColor() {
        return this.segmentColor;
    }

    public void setSegmentColor(Color color) {
        this.segmentColor = color;
    }

    public GPXExtension getExtension() {
        if (this.extension == null) {
            this.extension = new GPXExtension("extensions");
        }
        return this.extension;
    }

    public void setExtension(GPXExtension gPXExtension) {
        this.extension = gPXExtension;
    }

    public double getDistance(Waypoint waypoint) {
        double d = 0.0;
        if (waypoint != null && Double.isNaN(d = OsmMercator.MERCATOR_256.getDistance(this.getLat(), this.getLon(), waypoint.getLat(), waypoint.getLon()))) {
            d = 0.0;
        }
        return d;
    }

    public long getDuration(Waypoint waypoint) {
        long l = 0L;
        if (waypoint != null && this.getTime() != null && waypoint.getTime() != null) {
            l = waypoint.getTime().getTime() - this.getTime().getTime();
        }
        return l / 1000L;
    }

    @Override
    public int compareTo(Waypoint waypoint) {
        if (this.getTime() == null || waypoint.getTime() == null) {
            return 0;
        }
        return this.getTime().compareTo(waypoint.getTime());
    }
}

