/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import eu.fuegenstein.unit.UnitConverter;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gpsmaster.dialogs.GenericDownloadDialog;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.online.OnlineTrack;
import org.gpsmaster.online.OsmTableModel;
import org.gpsmaster.osm.Osm;
import org.gpsmaster.osm.OsmQuery;
import se.kodapan.osm.domain.Relation;
import se.kodapan.osm.domain.root.PojoRoot;
import se.kodapan.osm.parser.xml.OsmXmlParserException;
import se.kodapan.osm.services.overpass.OverpassException;

public class DownloadOsm
extends GenericDownloadDialog {
    private static final long serialVersionUID = 7474104853346542164L;
    private JButton getListButton = new JButton();
    private JComboBox<String> typeCombo = new JComboBox();
    protected JTextField idField = null;
    private JTextField nameField = null;
    private Osm osm = null;
    private OsmQuery osmQuery = new OsmQuery();
    private long customId = 0L;
    private final List<TransferableItem> items = Collections.synchronizedList(new ArrayList());

    public DownloadOsm(JFrame jFrame, MessageCenter messageCenter, FileHub fileHub, UnitConverter unitConverter) {
        super(jFrame, messageCenter, fileHub, unitConverter);
        this.osm = new Osm(messageCenter);
        this.idField = new JTextField();
        this.setIcon("/org/gpsmaster/icons/downloadbar/", "download-osm.png");
        this.setupLists();
        this.setupFilterPanel();
        this.addIdField();
        this.pack();
    }

    private void setupLists() {
        this.typeCombo.addItem("<All>");
        this.typeCombo.addItem("bicycle");
        this.typeCombo.addItem("hiking");
        this.typeCombo.addItem("road");
        this.typeCombo.addItem("train");
        this.typeCombo.addItem("tram");
        this.typeCombo.addItem("foot");
        this.typeCombo.addItem("bus");
        this.typeCombo.addItem("detour");
        this.typeCombo.addItem("horse");
        this.typeCombo.addItem("ski");
    }

    private void addIdField() {
        this.buttonPanel.add(new JLabel("download by ID:"));
        this.idField.setPreferredSize(new Dimension(50, 20));
        this.idField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DownloadOsm.this.checkCustomId();
                }
            }
        });
        this.idField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DownloadOsm.this.checkCustomId();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.buttonPanel.add(this.idField);
    }

    private void setupFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setVisible(true);
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("Type:"));
        jPanel.add(this.typeCombo);
        jPanel.add(new JLabel("name contains:"));
        this.nameField = new JTextField();
        this.nameField.setPreferredSize(new Dimension(100, 20));
        jPanel.add(this.nameField);
        this.getListButton.setText("Get List");
        this.getListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadOsm.this.getRelationList();
            }
        });
        jPanel.add(this.getListButton);
        this.northPanel.add(jPanel);
        this.pack();
    }

    private void checkCustomId() {
        try {
            this.customId = Long.parseLong(this.idField.getText());
            this.loadButton.setEnabled(true);
            this.loadButton.requestFocus();
        }
        catch (NumberFormatException numberFormatException) {
            if (this.trackListModel.getRowCount() == 0) {
                this.loadButton.setEnabled(false);
            }
            this.idField.setText("0");
            this.customId = 0L;
        }
    }

    private void getRelationList() {
        this.busyOn();
        MessagePanel messagePanel = this.msg.infoOn("Retrieving list of relations for current map view ...");
        this.trackListModel.clear();
        this.osmQuery.setType(2);
        this.osmQuery.setCaseSensitive(false);
        this.osmQuery.setUseRegExp(true);
        this.osmQuery.setGeoBounds(this.getGeoBounds());
        if (this.typeCombo.getSelectedIndex() > 0) {
            this.osmQuery.addTag("route", (String)this.typeCombo.getSelectedItem());
        }
        if (!this.nameField.getText().isEmpty()) {
            this.osmQuery.addTag("name", this.nameField.getText());
        }
        try {
            this.osm.addQuery(this.osmQuery);
            PojoRoot pojoRoot = this.osm.runQuery();
            for (long l : pojoRoot.getRelations().keySet()) {
                Relation relation = pojoRoot.getRelations().get(l);
                OnlineTrack onlineTrack = new OnlineTrack();
                onlineTrack.setId(l);
                onlineTrack.setName(relation.getTag("name"));
                onlineTrack.setType(relation.getTag("type"));
                if (onlineTrack.getName() == null) {
                    onlineTrack.setName("(" + l + ")");
                }
                onlineTrack.setWebUrl("http://www.openstreetmap.org/relation/" + l);
                this.trackListModel.addItem(onlineTrack);
            }
        }
        catch (OverpassException overpassException) {
            this.msg.volatileError(overpassException);
        }
        catch (OsmXmlParserException osmXmlParserException) {
            this.msg.volatileError(osmXmlParserException);
        }
        this.trackTable.minimizeColumnWidth(1, 0);
        this.msg.infoOff(messagePanel);
        this.msg.volatileInfo(this.trackListModel.getRowCount() + " relations found.");
        this.busyOff();
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "Relation Name";
        }
        return "----";
    }

    @Override
    protected void loadSelected() {
        int n;
        if (this.customId != 0L) {
            OnlineTrack onlineTrack = new OnlineTrack();
            onlineTrack.setName("OSM Relation " + this.customId);
            onlineTrack.setId(this.customId);
            this.items.add(onlineTrack);
        }
        if ((n = this.trackTable.getSelectedRowCount()) > 0) {
            int[] nArray = this.trackTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.trackTable.convertRowIndexToModel(nArray[i]);
                if (n2 < 0 || n2 >= this.trackListModel.getRowCount()) continue;
                TransferableItem transferableItem = this.trackListModel.getItem(n2);
                transferableItem.setTransferState(1);
                this.items.add(transferableItem);
            }
        }
        this.trackTable.clearSelection();
        this.fileHub.run();
    }

    @Override
    public String getName() {
        return "OpenStreetMap";
    }

    @Override
    public String getTitle() {
        return "Download Route from OpenStreetMap";
    }

    @Override
    public boolean doShowProgressText() {
        return true;
    }

    @Override
    public DataType getDataType() {
        return DataType.GPXFILE;
    }

    @Override
    public List<TransferableItem> getItems() {
        return this.items;
    }

    @Override
    public GPXFile getGpxFile(TransferableItem transferableItem) throws Exception {
        GPXFile gPXFile = new GPXFile();
        OnlineTrack onlineTrack = (OnlineTrack)transferableItem;
        gPXFile.setName(onlineTrack.getName());
        gPXFile.setDesc("OSM Relation " + onlineTrack.getId());
        this.osm.downloadRelation(onlineTrack.getId(), gPXFile);
        return gPXFile;
    }

    @Override
    public void open(TransferableItem transferableItem) {
    }

    @Override
    public InputStream getInputStream() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    protected void setupTableModel() {
        this.trackListModel = new OsmTableModel(this.uc);
    }

    @Override
    protected void setupTable() {
        this.trackTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    }

    @Override
    public void begin() {
        this.descPanel.setVisible(false);
    }
}

