/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.gpsmaster.online.GpsiesTableModel;
import org.gpsmaster.online.OnlineTrack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GpsiesXmlHandler
extends DefaultHandler {
    private String value = null;
    private GpsiesTableModel tracklistModel = null;
    private OnlineTrack track = null;
    private DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S");

    public GpsiesXmlHandler(GpsiesTableModel gpsiesTableModel) {
        this.tracklistModel = gpsiesTableModel;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("track")) {
            this.track = new OnlineTrack();
        }
        this.value = null;
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("track")) {
            this.tracklistModel.addItem(this.track);
        } else if (string3.equals("title")) {
            this.track.setName(this.value);
        } else if (string3.equals("description")) {
            this.track.setDescription(this.value);
        } else if (string3.equals("fileId")) {
            this.track.setWebUrl("http://gpsies.com/map.do?fileId=" + this.value);
        } else if (string3.equals("trackLengthM")) {
            try {
                this.track.setLength((long)Double.parseDouble(this.value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string3.equals("downloadLink")) {
            this.track.setDownloadLink(this.value);
            this.track.setSourceFormat("gpx");
        } else if (string3.equals("changedDate")) {
            try {
                this.track.setDate(this.sdf.parse(this.value));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.value = this.value == null ? string : this.value + string;
        super.characters(cArray, n, n2);
    }
}

