/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.gpsmaster.dialogs.BrowserLauncher;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.dialogs.GuiGridLayout;
import org.gpsmaster.gpsloader.GpxLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.online.FormPoster;

public class UploadGpsies
extends GenericDialog {
    private static final long serialVersionUID = -1243245722161680913L;
    private JTextField usernameField = null;
    private JPasswordField passwordField = null;
    private JTextField nameField = null;
    private JTextArea descField = null;
    private JCheckBox privateCheckbox = null;
    private JCheckBox[] activityCheckboxes = null;
    private JButton uploadButton = null;
    private JButton webButton = null;
    private String pageUrl = null;
    private String activity = "Biking";
    private static final String GPSIES_URL = "http://www.gpsies.com/upload.do";
    private static final String GPSIES_DEVICE = "GpsMaster";
    private static final String[] ACTIVITY_KEYS = new String[]{"trekking", "walking", "jogging", "skating", "crossskating", "handcycle", "biking", "racingbike", "mountainbiking", "motorbiking", "cabriolet", "car", "skiingNordic", "skiingAlpine", "snowshoe", "wintersports", "riding", "canoeing", "sailing", "boating", "climbing", "flying", "train", "sightseeing", "geocaching", "miscellaneous"};
    private MessageCenter msg = null;
    private GPXFile gpx = null;
    private PipedInputStream iStream = null;
    private PipedOutputStream oStream = null;

    public UploadGpsies(GPXFile gPXFile, JFrame jFrame, MessageCenter messageCenter) {
        super(jFrame, messageCenter);
        this.msg = messageCenter;
        this.gpx = gPXFile;
        this.usernameField = new JTextField(20);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        guiGridLayout.add(new JLabel("Username"));
        guiGridLayout.add(this.usernameField);
        guiGridLayout.add(new JLabel("Password"));
        this.passwordField = new JPasswordField(20);
        guiGridLayout.add(this.passwordField);
        guiGridLayout.add(new JLabel("Name"));
        this.nameField = new JTextField(20);
        guiGridLayout.add(this.nameField);
        guiGridLayout.add(new JLabel("Description"));
        this.descField = new JTextArea(5, 20);
        this.descField.setLineWrap(true);
        this.descField.setWrapStyleWord(true);
        guiGridLayout.add(new JScrollPane(this.descField));
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                UploadGpsies.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    UploadGpsies.this.dispose();
                }
            }
        };
        this.usernameField.addKeyListener(keyAdapter);
        this.passwordField.addKeyListener(keyAdapter);
        this.nameField.addKeyListener(keyAdapter);
        this.descField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    keyEvent.consume();
                    if (keyEvent.isShiftDown()) {
                        UploadGpsies.this.nameField.requestFocusInWindow();
                    } else {
                        UploadGpsies.this.privateCheckbox.requestFocusInWindow();
                    }
                }
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && (keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 127)) {
                    UploadGpsies.this.passwordField.setText("");
                }
            }
        });
        guiGridLayout.add(new JLabel("Keep private"));
        this.privateCheckbox = new JCheckBox();
        this.privateCheckbox.setSelected(false);
        guiGridLayout.add(this.privateCheckbox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder(1));
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                UploadGpsies.this.enableOK();
            }
        };
        GuiGridLayout guiGridLayout2 = new GuiGridLayout(jPanel3, new double[]{1.0, 1.0}, new boolean[]{false, false});
        int n = ACTIVITY_KEYS.length;
        this.activityCheckboxes = new JCheckBox[n];
        for (int i = 0; i < n; ++i) {
            this.activityCheckboxes[i] = new JCheckBox(ACTIVITY_KEYS[i]);
            if (ACTIVITY_KEYS[i].equalsIgnoreCase(this.activity)) {
                this.activityCheckboxes[i].setSelected(true);
            }
            this.activityCheckboxes[i].addChangeListener(changeListener);
            guiGridLayout2.add(this.activityCheckboxes[i]);
        }
        guiGridLayout.add(new JLabel("Activities"));
        guiGridLayout.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel2);
        jPanel.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this.webButton = new JButton("Show Webpage");
        this.webButton.setEnabled(false);
        this.webButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserLauncher.launchBrowser(UploadGpsies.this.pageUrl);
            }
        });
        jPanel5.add(this.webButton);
        this.uploadButton = new JButton("Upload");
        this.uploadButton.setEnabled(false);
        this.uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UploadGpsies.this.startUpload();
            }
        });
        jPanel5.add(this.uploadButton);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UploadGpsies.this.dispose();
            }
        });
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        boolean bl;
        boolean bl2 = bl = this.usernameField.getText().length() > 0 && this.nameField.getText().length() > 0 && this.gpx != null;
        if (bl) {
            int n;
            char[] cArray = this.passwordField.getPassword();
            bl = cArray.length > 0;
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = 48;
            }
            if (bl) {
                bl = false;
                for (n = 0; n < this.activityCheckboxes.length; ++n) {
                    bl = bl || this.activityCheckboxes[n].isSelected();
                }
            }
        }
        this.uploadButton.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpload() {
        BufferedReader bufferedReader = null;
        this.setCursor(new Cursor(3));
        MessagePanel messagePanel = this.msg.infoOn("Uploading " + this.nameField.getText() + " to Gpsies.com ...");
        try {
            this.webButton.setEnabled(false);
            this.pageUrl = null;
            String string = this.usernameField.getText() + "|" + DigestUtils.md5Hex((String)this.passwordField.getText());
            String string2 = new String(Base64.encodeBase64((byte[])string.getBytes()));
            FormPoster formPoster = new FormPoster(new URL(GPSIES_URL));
            formPoster.setParameter("device", GPSIES_DEVICE);
            formPoster.setParameter("authenticateHash", string2);
            boolean bl = false;
            for (int i = 0; i < ACTIVITY_KEYS.length; ++i) {
                if (!this.activityCheckboxes[i].isSelected()) continue;
                bl = true;
                formPoster.setParameter("trackTypes", ACTIVITY_KEYS[i]);
            }
            if (!bl) {
                formPoster.setParameter("trackTypes", "walking");
            }
            formPoster.setParameter("filename", this.nameField.getText());
            formPoster.setParameter("fileDescription", this.descField.getText());
            formPoster.setParameter("status", this.privateCheckbox.isSelected() ? "3" : "1");
            formPoster.setParameter("uploadButton", "speichern");
            this.iStream = new PipedInputStream();
            this.oStream = new PipedOutputStream(this.iStream);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    GpxLoader gpxLoader = new GpxLoader();
                    gpxLoader.save(UploadGpsies.this.gpx, UploadGpsies.this.oStream);
                    try {
                        UploadGpsies.this.oStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }).start();
            formPoster.setParameter("formFile", this.nameField.getText(), this.iStream);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(formPoster.post());
            int n = formPoster.getResponseCode();
            bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            String string3 = bufferedReader.readLine();
            if (n == 200 && string3.substring(0, 2).toUpperCase().equals("OK")) {
                int n2 = string3.indexOf(91);
                if (n2 > 0 && string3.endsWith("]")) {
                    this.pageUrl = string3.substring(n2 + 1, string3.length() - 1);
                }
                this.msg.volatileInfo("Upload finished.");
            }
            if (this.pageUrl != null) {
                this.webButton.setEnabled(true);
                this.firePropertyChange("gpsiesUsername", null, this.usernameField.getText());
                if (this.gpx.getExtension().containsKey("gpsm:gpsiesurl")) {
                    this.gpx.getExtension().remove("gpsm:gpsiesurl");
                }
                this.gpx.getExtension().add("gpsm:gpsiesurl", this.pageUrl);
            } else {
                this.msg.error("Upload failed: " + string3);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            this.msg.error("Upload failed", iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            this.msg.infoOff(messagePanel);
            this.setCursor(new Cursor(0));
        }
    }

    public String getUsername() {
        return this.usernameField.getText();
    }

    public void setUsername(String string) {
        this.usernameField.setText(string);
    }

    @Override
    public void begin() {
        this.setLocationRelativeTo(this.parentFrame);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.makeDialogComponents());
        this.setIcon("/org/gpsmaster/icons/downloadbar/", "gpsies-up.png");
        this.pack();
        this.setCenterLocation();
        this.setVisible(true);
        if (this.gpx.getName() != null) {
            this.nameField.setText(this.gpx.getName());
        }
        if (this.gpx.getDesc() != null) {
            this.descField.setText(this.gpx.getDesc());
        }
        if (this.gpx.getExtension().containsKey("gpsm:activity")) {
            this.activity = this.gpx.getExtension().getSubValue("gpsm:activity");
        }
    }

    @Override
    public String getTitle() {
        return "Upload to www.gpsies.com";
    }
}

