/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import org.gpsmaster.online.OnlineTrack;
import org.gpsmaster.online.WikiTableModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WikiXmlHandler
extends DefaultHandler {
    private String value = null;
    private OnlineTrack track = null;
    private String lat = null;
    private String lon = null;
    private String errorMessage = null;
    private WikiTableModel tableModel = null;

    public WikiXmlHandler(WikiTableModel wikiTableModel) {
        this.tableModel = wikiTableModel;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("entry")) {
            this.track = new OnlineTrack();
            this.lat = null;
            this.lon = null;
        } else if (string3.equals("status")) {
            this.errorMessage = attributes.getValue("message");
        } else {
            this.value = null;
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("entry")) {
            this.track.setDownloadLink(this.lat + "," + this.lon);
            this.tableModel.addItem(this.track);
        } else if (string3.equals("title")) {
            this.track.setName(this.value);
        } else if (string3.equals("summary")) {
            this.track.setDescription(this.value);
        } else if (string3.equals("lat")) {
            this.lat = this.value;
        } else if (string3.equals("lng")) {
            this.lon = this.value;
        } else if (string3.equals("distance")) {
            try {
                this.track.setLength((long)(Double.parseDouble(this.value) * 1000.0));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string3.equals("wikipediaUrl")) {
            this.track.setWebUrl(this.value.replaceFirst("http://", "https://"));
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.value = this.value == null ? string : this.value + string;
        super.characters(cArray, n, n2);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

