/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.pathfinder;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.RoutePointMarker;
import org.gpsmaster.pathfinder.RouteProvider;
import org.gpsmaster.pathfinder.RouteRequestInfo;
import org.gpsmaster.widget.PathFinderWidget;

public class PathFinder {
    private RouteProvider routeProvider = null;
    private Route activeRoute = null;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("activeGpxObject")) {
                PathFinder.this.setGpxObject();
            }
        }
    };
    private GPXFile gpxFile = null;
    private List<RouteRequestInfo> requests = null;
    private PathFinderWidget widget = null;
    private MessageCenter msg = null;
    private SwingWorker<Void, Void> pathFindWorker = null;

    public PathFinder() {
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.requests = Collections.synchronizedList(new ArrayList());
        this.makePathFindWorker();
    }

    public PathFinder(RouteProvider routeProvider) {
        this();
        this.routeProvider = routeProvider;
    }

    public RouteProvider getRouteProvider() {
        return this.routeProvider;
    }

    public void setRouteProvider(RouteProvider routeProvider) {
        this.routeProvider = routeProvider;
    }

    public void setWidget(PathFinderWidget pathFinderWidget) {
        this.widget = pathFinderWidget;
    }

    public void setMessageCenter(MessageCenter messageCenter) {
        this.msg = messageCenter;
    }

    public void findRoute(Waypoint waypoint) throws Exception {
        RoutePointMarker routePointMarker = null;
        if (this.activeRoute == null) {
            throw new IllegalArgumentException("No active route");
        }
        if (this.routeProvider == null) {
            throw new IllegalArgumentException("Route provider not set");
        }
        routePointMarker = new RoutePointMarker(waypoint);
        routePointMarker.setRouteProvider(this.routeProvider);
        routePointMarker.setRoute(this.activeRoute);
        this.gpxFile.getWaypointGroup().getWaypoints().add(routePointMarker);
        RouteRequestInfo routeRequestInfo = new RouteRequestInfo();
        routeRequestInfo.setState(0);
        routeRequestInfo.destination = waypoint;
        routeRequestInfo.route = this.activeRoute;
        routeRequestInfo.gpxFile = this.gpxFile;
        routeRequestInfo.provider = this.routeProvider;
        routeRequestInfo.transport = this.routeProvider.getTransportType();
        routeRequestInfo.routeMarker = routePointMarker;
        GpsMaster.active.addUndoOperation(routeRequestInfo);
        GpsMaster.active.repaintMap();
        if (this.activeRoute.getNumPts() == 0) {
            this.activeRoute.getPath().addWaypoint(waypoint);
            routeRequestInfo.setState(2);
            return;
        }
        this.requests.add(routeRequestInfo);
        if (this.pathFindWorker.getState() == SwingWorker.StateValue.DONE) {
            this.makePathFindWorker();
        }
        this.pathFindWorker.execute();
    }

    public void setGpxObject() {
        this.activeRoute = null;
        if (GpsMaster.active.getGpxObject() != null) {
            if (GpsMaster.active.getGpxObject() instanceof Route) {
                this.activeRoute = (Route)GpsMaster.active.getGpxObject();
            } else if (GpsMaster.active.getGpxFile().isGPXFileWithOneRoute()) {
                this.activeRoute = GpsMaster.active.getGpxFile().getRoutes().get(0);
            }
            this.gpxFile = GpsMaster.active.getGpxFile();
        }
    }

    public void Cancel() {
        this.pathFindWorker.cancel(true);
        for (RouteRequestInfo routeRequestInfo : this.requests) {
            this.gpxFile.getWaypointGroup().getWaypoints().remove(routeRequestInfo.routeMarker);
        }
        this.requests.clear();
    }

    public void clear() {
        this.requests.clear();
    }

    private void makePathFindWorker() {
        this.pathFindWorker = new SwingWorker<Void, Void>(){
            RouteRequestInfo request = null;
            List<Waypoint> newSegment = new ArrayList<Waypoint>();
            MessagePanel infoPanel = null;

            @Override
            protected Void doInBackground() throws Exception {
                PathFinder.this.widget.setBusy(true);
                if (PathFinder.this.msg != null) {
                    this.infoPanel = PathFinder.this.msg.infoOn("", new Cursor(3));
                }
                int n = PathFinder.this.requests.size();
                while (n > 0) {
                    block6: {
                        this.request = (RouteRequestInfo)PathFinder.this.requests.get(0);
                        if (this.request.getState() == 0) {
                            this.request.setState(1);
                            try {
                                List<Waypoint> list = this.request.route.getPath().getWaypoints();
                                Waypoint waypoint = list.get(list.size() - 1);
                                Waypoint waypoint2 = this.request.destination;
                                this.infoPanel.setText(String.format("finding path to %.6f, %.6f (%s) ... ", waypoint2.getLat(), waypoint2.getLon(), this.request.provider.getName()));
                                this.request.provider.findRoute(this.newSegment, waypoint.getLat(), waypoint.getLon(), waypoint2.getLat(), waypoint2.getLon());
                                if (!this.isCancelled() && this.request.getState() != 3) {
                                    this.request.setStartIdx(this.request.route.getPath().getWaypoints().size() - 1);
                                    this.request.route.getPath().getWaypoints().addAll(this.newSegment);
                                    this.request.route.updateAllProperties();
                                    GpsMaster.active.repaintMap();
                                    GpsMaster.active.refresh();
                                }
                                this.request.setState(2);
                            }
                            catch (Exception exception) {
                                if (PathFinder.this.msg == null) break block6;
                                PathFinder.this.msg.error(exception);
                            }
                        }
                    }
                    PathFinder.this.requests.remove(this.request);
                    this.newSegment.clear();
                    n = PathFinder.this.requests.size();
                }
                return null;
            }

            @Override
            protected void done() {
                if (PathFinder.this.msg != null) {
                    PathFinder.this.msg.infoOff(this.infoPanel);
                }
                PathFinder.this.widget.setBusy(false);
            }
        };
    }
}

