/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.pathfinder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.gpsmaster.ConnectivityType;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.pathfinder.RouteProvider;
import org.gpsmaster.pathfinder.Transport;
import org.gpsmaster.pathfinder.TransportType;

public class RouteProviderMapQuest
extends RouteProvider {
    protected final Locale requestLocale = new Locale("en", "US");
    protected List<Transport> routeTypes = null;

    @Override
    public String getName() {
        return "MapQuest";
    }

    @Override
    public String getDescription() {
        return "http://www.mapquest.com/";
    }

    @Override
    public String getAttribution() {
        return "<attribution mapquest>";
    }

    @Override
    public long getMaxDistance() {
        return 10000L;
    }

    @Override
    public ConnectivityType getConnectivityType() {
        return ConnectivityType.ONLINE;
    }

    @Override
    public List<Transport> getTransport() {
        if (this.routeTypes == null) {
            this.routeTypes = new ArrayList<Transport>();
            this.routeTypes.add(new Transport("Foot", TransportType.FOOT, "routeType=pedestrian"));
            this.routeTypes.add(new Transport("Bicycle", TransportType.BICYCLE, "routeType=bicycle&CyclingRoadFactor=10.0"));
            this.routeTypes.add(new Transport("Car (fastest)", TransportType.CAR, "routeType=fastest"));
            this.routeTypes.add(new Transport("Car (shortest)", TransportType.CAR, "routeType=shortest"));
        }
        return this.routeTypes;
    }

    @Override
    public void findRoute(List<Waypoint> list, double d, double d2, double d3, double d4) throws Exception {
        if (this.transport == null) {
            throw new IllegalArgumentException("transport not set");
        }
        String string = this.getXMLResponse(d, d2, d3, d4);
        List<Waypoint> list2 = this.parseXML(string);
        list.addAll(list2);
    }

    protected String getXMLResponse(double d, double d2, double d3, double d4) throws Exception {
        String string = "http://open.mapquestapi.com/directions/v1/route?key=1bAcGKAeLtJCNkwIbgo7kZrM0D48Dcjg&narrative=none&outFormat=xml&" + this.transport.urlParam + "&shapeFormat=raw&generalize=0&locale=en_US&unit=m&from=" + String.format(this.requestLocale, "%.6f,%.6f", d, d2) + "&to=" + String.format(this.requestLocale, "%.6f,%.6f", d3, d4);
        String string2 = "UTF-8";
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        uRLConnection = new URL(string).openConnection();
        uRLConnection.setRequestProperty("Accept-Charset", string2);
        inputStream = uRLConnection.getInputStream();
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            stringBuilder.append(string3);
            stringBuilder.append('\n');
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    protected List<Waypoint> parseXML(String string) throws Exception {
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        boolean bl = false;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        try {
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(byteArrayInputStream, "ISO-8859-1");
            while (xMLStreamReader.hasNext()) {
                xMLStreamReader.next();
                if (xMLStreamReader.getEventType() == 1 && xMLStreamReader.getLocalName().equals("shapePoints")) {
                    bl = true;
                }
                if (xMLStreamReader.getEventType() == 2 && xMLStreamReader.getLocalName().equals("shapePoints")) {
                    bl = false;
                }
                if (bl) {
                    if (xMLStreamReader.getEventType() == 1 && xMLStreamReader.getLocalName().equals("latLng")) {
                        bl2 = true;
                    }
                    if (xMLStreamReader.getEventType() == 2 && xMLStreamReader.getLocalName().equals("latLng")) {
                        bl2 = false;
                        Waypoint waypoint = new Waypoint(d, d2);
                        arrayList.add(waypoint);
                    }
                }
                if (!bl2) continue;
                if (xMLStreamReader.getEventType() == 1 && xMLStreamReader.getLocalName().equals("lat")) {
                    xMLStreamReader.next();
                    if (xMLStreamReader.isCharacters()) {
                        d = Double.parseDouble(xMLStreamReader.getText());
                    }
                }
                if (xMLStreamReader.getEventType() != 1 || !xMLStreamReader.getLocalName().equals("lng")) continue;
                xMLStreamReader.next();
                if (!xMLStreamReader.isCharacters()) continue;
                d2 = Double.parseDouble(xMLStreamReader.getText());
            }
            xMLStreamReader.close();
        }
        catch (Exception exception) {
            throw new Exception("There was a problem parsing the XML response.");
        }
        if (arrayList.size() > 0) {
            arrayList.remove(arrayList.get(0));
        }
        return arrayList;
    }
}

