/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.pathfinder;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.RoutePointMarker;
import org.gpsmaster.pathfinder.RouteProvider;
import org.gpsmaster.pathfinder.Transport;
import org.gpsmaster.undo.IUndoable;

public class RouteRequestInfo
implements IUndoable {
    public static final int STATE_PENDING = 0;
    public static final int STATE_PROCESSING = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_CANCELLED = 3;
    public Waypoint destination = null;
    public Route route = null;
    public GPXFile gpxFile = null;
    public RouteProvider provider = null;
    public Transport transport = null;
    public RoutePointMarker routeMarker = null;
    private final long lockTimeout = 5L;
    private ReentrantLock lock = new ReentrantLock();
    private int startIdx = -1;
    private int state = 0;

    public int getStartIdx() {
        return this.startIdx;
    }

    public void setStartIdx(int n) {
        this.startIdx = n;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) throws InterruptedException {
        this.lock();
        this.state = n;
        this.unlock();
    }

    @Override
    public String getUndoDescription() {
        return String.format("Find Path to (%.6f, %.6f) using %s (%s)", this.destination.getLat(), this.destination.getLon(), this.provider.getName(), this.transport.getName());
    }

    @Override
    public void undo() throws InterruptedException {
        this.lock();
        switch (this.state) {
            case 0: {
                this.removeRoutePointMarker();
                this.state = 3;
                break;
            }
            case 1: {
                this.removeRoutePointMarker();
                this.state = 3;
                break;
            }
            case 2: {
                int n;
                List<Waypoint> list = this.route.getPath().getWaypoints();
                for (int i = n = list.size() - 1; i > this.startIdx; --i) {
                    list.remove(i);
                }
                this.removeRoutePointMarker();
                this.state = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("State " + this.state);
            }
        }
        this.unlock();
    }

    private void lock() throws InterruptedException {
        this.lock.tryLock(5L, TimeUnit.SECONDS);
    }

    private void unlock() {
        this.lock.unlock();
    }

    private void removeRoutePointMarker() {
        this.gpxFile.getWaypointGroup().getWaypoints().remove(this.routeMarker);
    }
}

