/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.timeshift;

import java.util.Date;
import java.util.Hashtable;
import org.gpsmaster.Core;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.timeshift.TimeshiftAlgorithm;

public class ClearTimestamps
extends TimeshiftAlgorithm {
    private Hashtable<Waypoint, Date> undoLog = new Hashtable();

    public ClearTimestamps() {
        this.name = "Clear";
        this.description = "remove all timestamps";
    }

    @Override
    public boolean isApplicable() {
        return this.waypointGroups.size() > 0;
    }

    @Override
    public void apply() {
        for (WaypointGroup waypointGroup : this.waypointGroups) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                Date date = waypoint.getTime();
                if (date == null) continue;
                this.undoLog.put(waypoint, date);
            }
            Core.clearTimestamps(waypointGroup);
        }
    }

    @Override
    public String getUndoDescription() {
        return this.description;
    }

    @Override
    public void undo() {
        for (WaypointGroup waypointGroup : this.waypointGroups) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                if (!this.undoLog.containsKey(waypoint)) continue;
                waypoint.setTime(this.undoLog.get(waypoint));
            }
        }
    }
}

