/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.marker.Marker;

public class GPXTree
extends JTree {
    private GPXObject gpxObj;
    private JColorChooser colorChooser;
    private DefaultTreeModel treeModel;
    private JDialog dialog;
    private ActionListener colorListener = null;
    private BufferedImage paletteIcon = null;
    private Icon removeIcon = null;
    private Icon addIcon = null;
    private JMenuItem removeItem = null;
    private JMenuItem toRouteItem = null;
    private JMenuItem toTrackItem = null;
    private JMenuItem addRouteItem = null;
    private ArrayList<TreePath> expandedPaths = new ArrayList();
    private boolean saveExpansionState = false;

    public GPXTree(DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        final DefaultTreeModel defaultTreeModel2 = defaultTreeModel;
        this.treeModel = defaultTreeModel;
        this.colorChooser = new JColorChooser();
        this.colorListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXTree.this.gpxObj.setColor(GPXTree.this.colorChooser.getColor());
                GpsMaster.active.refresh();
                defaultTreeModel2.nodeChanged((TreeNode)defaultTreeModel2.getRoot());
            }
        };
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                System.out.println("treeExpanded");
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                System.out.println("treeCollapsed");
            }
        });
        try {
            this.paletteIcon = ImageIO.read(GpsMaster.class.getResourceAsStream("/org/gpsmaster/icons/color-palette.png"));
            this.removeIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/tree/tree-remove.png"));
            this.addIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/tree/tree-add.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.removeItem = new JMenuItem("Remove", this.removeIcon);
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXTree.this.firePropertyChange("removeGpx", null, null);
            }
        });
        this.toTrackItem = new JMenuItem("Convert to Track");
        this.toTrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXTree.this.firePropertyChange("toTrack", null, null);
            }
        });
        this.toRouteItem = new JMenuItem("Convert to Route");
        this.toRouteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXTree.this.firePropertyChange("toRoute", null, null);
            }
        });
        this.addRouteItem = new JMenuItem("Add Route", this.addIcon);
        this.addRouteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXTree.this.firePropertyChange("addRoute", null, null);
            }
        });
        this.setScrollsOnExpand(true);
        this.setExpandsSelectedPaths(true);
    }

    public void setColorChooser(JColorChooser jColorChooser) {
        this.colorChooser = jColorChooser;
    }

    public void setSelectedGpxObject(GPXObject gPXObject) {
        if (gPXObject != null) {
            this.setSelectionPath(new TreePath(this.treeModel.getPathToRoot(gPXObject)));
        }
    }

    public void refresh(TreeNode treeNode) {
        this.expandedPaths.clear();
        if (treeNode.getParent() != null) {
            this.treeModel.nodeStructureChanged(treeNode.getParent());
        } else {
            this.treeModel.nodeStructureChanged(treeNode);
        }
    }

    private void saveExpansionState(TreeNode treeNode) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(treeNode));
        if (this.isExpanded(treePath)) {
            this.expandedPaths.add(treePath);
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.saveExpansionState(treeNode.getChildAt(i));
        }
    }

    private void restoreExpansionState() {
        for (TreePath treePath : this.expandedPaths) {
            this.expandPath(treePath);
        }
        this.expandedPaths.clear();
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n4 == -1) {
            super.processMouseEvent(mouseEvent);
            return;
        }
        TreePath treePath = this.getPathForLocation(n2, n3);
        if (treePath.getLastPathComponent() instanceof Marker) {
            super.processMouseEvent(mouseEvent);
            return;
        }
        this.gpxObj = (GPXObject)treePath.getLastPathComponent();
        if (mouseEvent.isPopupTrigger()) {
            System.out.println("popuptrigger " + mouseEvent.getSource().toString());
            this.setSelectionRow(n4);
            if (this.gpxObj instanceof Route) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(this.removeItem);
                jPopupMenu.add(this.toTrackItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (this.gpxObj instanceof Track) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(this.removeItem);
                jPopupMenu.add(this.toRouteItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (this.gpxObj instanceof GPXFile) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(this.addRouteItem);
                jPopupMenu.add(this.removeItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(this.removeItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (n != 500 && n != 502) {
            if (n == 501) {
                int n5 = n2;
                int n6 = n4;
                while (n6 == n4) {
                    n6 = this.getRowForLocation(--n5, n3);
                }
                ++n5;
                int n7 = n3;
                n6 = n4;
                while (n6 == n4) {
                    n6 = this.getRowForLocation(n2, --n7);
                }
                n3 -= ++n7;
                if ((n2 -= n5) >= 0 && n2 <= 9) {
                    if (n3 >= 4 && n3 <= 12) {
                        this.gpxObj.setVisible(!this.gpxObj.isVisible());
                    }
                } else if (n2 >= 13 && n2 <= 19) {
                    if (n3 >= 4 && n3 <= 12) {
                        this.gpxObj.setTrackPtsVisible(!this.gpxObj.isTrackPtsVisible());
                    }
                } else if (n2 >= 23 && n2 <= 32) {
                    if (n3 >= 4 && n3 <= 12) {
                        this.dialog = JColorChooser.createDialog(null, "Choose a Color", true, this.colorChooser, this.colorListener, null);
                        this.dialog.setIconImage(this.paletteIcon);
                        this.colorChooser.setColor(this.gpxObj.getColor());
                        this.dialog.setVisible(true);
                    }
                } else if (n2 > 36) {
                    this.clearSelection();
                    super.processMouseEvent(mouseEvent);
                }
                this.treeModel.nodeChanged(this.gpxObj);
                this.repaint();
                GpsMaster.active.repaintMap();
            } else {
                super.processMouseEvent(mouseEvent);
            }
        }
    }
}

