/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.widget;

import eu.fuegenstein.swing.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.gpsmaster.pathfinder.PathFinder;
import org.gpsmaster.pathfinder.RouteProvider;
import org.gpsmaster.pathfinder.Transport;

public class PathFinderWidget
extends Widget {
    private static final long serialVersionUID = 1620520040789173557L;
    private final Border CELLBORDER = new CompoundBorder(new LineBorder(Color.GRAY), new EmptyBorder(2, 4, 2, 4));
    private final Color BACKGROUNDSELECTED = new Color(177, 177, 25, 128);
    private final Color LABELBACKGROUND = new Color(255, 255, 255, 0);
    private final Color CANCELBACKGROUND = new Color(177, 25, 25, 208);
    private PathFinder pathFinder = null;
    private JPanel providerPanel = null;
    private JPanel transportPanel = null;
    private List<ProviderLabel> providerLabels = new ArrayList<ProviderLabel>();
    private List<TransportLabel> transportLabels = new ArrayList<TransportLabel>();
    private JPanel cancelPanel = new JPanel();
    private PropertyChangeListener cancelListener = null;

    public PathFinderWidget(final PathFinder pathFinder) {
        super(0);
        this.pathFinder = pathFinder;
        this.pathFinder.setWidget(this);
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(this.BACKGROUNDCOLOR);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Select Route Provider"));
        jPanel.setAlignmentX(0.5f);
        jPanel.setBackground(this.BACKGROUNDCOLOR);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.BACKGROUNDCOLOR);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.providerPanel = new JPanel();
        this.providerPanel.setLayout(new BoxLayout(this.providerPanel, 1));
        this.providerPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.providerPanel.setBackground(this.BACKGROUNDCOLOR);
        this.providerPanel.setAlignmentY(0.0f);
        jPanel2.add(this.providerPanel);
        this.transportPanel = new JPanel();
        this.transportPanel.setLayout(new BoxLayout(this.transportPanel, 1));
        this.transportPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.transportPanel.setBackground(this.BACKGROUNDCOLOR);
        this.transportPanel.setAlignmentY(0.0f);
        jPanel2.add(this.transportPanel);
        this.add(jPanel2);
        this.cancelPanel.add(new JLabel("Cancel"));
        this.cancelPanel.setBackground(this.CANCELBACKGROUND);
        this.cancelPanel.setOpaque(true);
        this.cancelPanel.setVisible(false);
        this.cancelPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                pathFinder.Cancel();
            }
        });
        this.add(this.cancelPanel);
    }

    public PathFinder getPathFinder() {
        return this.pathFinder;
    }

    public void setPathFinder(PathFinder pathFinder) {
        this.pathFinder = pathFinder;
    }

    public void setRouteProviders(List<RouteProvider> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("empty provider list");
        }
        this.clearProviderPanel();
        this.makeProviderPanel(list);
        this.setCurrentProvider(this.providerLabels.get(0));
        this.setCurrentTransport(this.transportLabels.get(0));
    }

    public void setBusy(boolean bl) {
        this.cancelPanel.setVisible(bl);
    }

    private void makeTransportPanel(List<Transport> list) {
        int n = 0;
        int n2 = 0;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TransportLabel transportLabel = (TransportLabel)mouseEvent.getSource();
                PathFinderWidget.this.setCurrentTransport(transportLabel);
            }
        };
        for (Transport object : list) {
            TransportLabel transportLabel = new TransportLabel();
            transportLabel.setTransport(object);
            transportLabel.addMouseListener(mouseAdapter);
            transportLabel.setOpaque(true);
            transportLabel.setBorder(this.CELLBORDER);
            transportLabel.setBackground(this.LABELBACKGROUND);
            n = Math.max(n, transportLabel.getPreferredSize().width);
            n2 = Math.max(n2, transportLabel.getPreferredSize().height);
            this.transportLabels.add(transportLabel);
            this.transportPanel.add(transportLabel);
        }
        Dimension dimension = new Dimension(n, n2);
        for (TransportLabel transportLabel : this.transportLabels) {
            transportLabel.setPreferredSize(dimension);
            transportLabel.setMaximumSize(dimension);
            transportLabel.setMinimumSize(dimension);
        }
        this.transportPanel.revalidate();
    }

    private void makeProviderPanel(List<RouteProvider> list) {
        int n = 0;
        int n2 = 0;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ProviderLabel providerLabel = (ProviderLabel)mouseEvent.getSource();
                PathFinderWidget.this.setCurrentProvider(providerLabel);
                PathFinderWidget.this.clearTransportPanel();
                PathFinderWidget.this.makeTransportPanel(providerLabel.getRouteProvider().getTransport());
                PathFinderWidget.this.setCurrentTransport((TransportLabel)PathFinderWidget.this.transportLabels.get(0));
            }
        };
        for (RouteProvider object : list) {
            ProviderLabel providerLabel = new ProviderLabel();
            providerLabel.setRouteProvider(object);
            providerLabel.setToolTipText(object.getDescription());
            providerLabel.addMouseListener(mouseAdapter);
            providerLabel.setOpaque(true);
            providerLabel.setBorder(this.CELLBORDER);
            providerLabel.setBackground(this.LABELBACKGROUND);
            n = Math.max(n, providerLabel.getPreferredSize().width);
            n2 = Math.max(n2, providerLabel.getPreferredSize().height);
            this.providerLabels.add(providerLabel);
            this.providerPanel.add(providerLabel);
        }
        Dimension dimension = new Dimension(n, n2);
        for (ProviderLabel providerLabel : this.providerLabels) {
            providerLabel.setPreferredSize(dimension);
            providerLabel.setMaximumSize(dimension);
            providerLabel.setMinimumSize(dimension);
        }
        this.providerPanel.revalidate();
    }

    private void setCurrentProvider(ProviderLabel providerLabel) {
        for (ProviderLabel providerLabel2 : this.providerLabels) {
            if (providerLabel2.equals(providerLabel)) {
                System.out.println("current provider = " + providerLabel.getRouteProvider().getName());
                providerLabel2.setBackground(this.BACKGROUNDSELECTED);
                this.pathFinder.setRouteProvider(providerLabel2.getRouteProvider());
                this.clearTransportPanel();
                this.makeTransportPanel(providerLabel2.getRouteProvider().getTransport());
                continue;
            }
            providerLabel2.setBackground(this.BACKGROUNDCOLOR);
        }
    }

    private void setCurrentTransport(TransportLabel transportLabel) {
        for (TransportLabel transportLabel2 : this.transportLabels) {
            if (transportLabel2.equals(transportLabel)) {
                System.out.println("current transport = " + transportLabel.getTransport().getName());
                transportLabel2.setBackground(this.BACKGROUNDSELECTED);
                this.pathFinder.getRouteProvider().setRouteType(transportLabel2.getTransport());
                continue;
            }
            transportLabel2.setBackground(this.BACKGROUNDCOLOR);
        }
    }

    private void clearProviderPanel() {
        for (ProviderLabel providerLabel : this.providerLabels) {
            this.providerPanel.remove(providerLabel);
        }
        this.providerLabels.clear();
    }

    private void clearTransportPanel() {
        for (TransportLabel transportLabel : this.transportLabels) {
            this.transportPanel.remove(transportLabel);
        }
        this.transportLabels.clear();
    }

    private class TransportLabel
    extends JLabel {
        private static final long serialVersionUID = -2139638356031334870L;
        private Transport transport = null;

        private TransportLabel() {
        }

        public Transport getTransport() {
            return this.transport;
        }

        public void setTransport(Transport transport) {
            this.transport = transport;
            this.setText(transport.getName());
            this.setToolTipText(transport.getDescription());
        }
    }

    private class ProviderLabel
    extends JLabel {
        private static final long serialVersionUID = 7696895198511994447L;
        private RouteProvider provider = null;

        private ProviderLabel() {
        }

        public RouteProvider getRouteProvider() {
            return this.provider;
        }

        public void setRouteProvider(RouteProvider routeProvider) {
            this.provider = routeProvider;
            this.setText(routeProvider.getName());
        }
    }
}

