/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.widget;

import eu.fuegenstein.swing.Widget;
import eu.fuegenstein.unit.Unit;
import eu.fuegenstein.unit.UnitConverter;
import eu.fuegenstein.unit.UnitFactory;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.gpsmaster.gpxpanel.GPXPanel;

public class ScalebarWidget
extends Widget {
    private GPXPanel mapPanel = null;
    private Unit mapUnit = UnitFactory.METER;
    private UnitConverter uc = null;
    private final int[] scales = new int[]{20000, 10000, 5000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 1};
    private final int barHeight = 12;
    private final int textOffset = 5;
    private static final long serialVersionUID = -1491190815019113326L;

    public ScalebarWidget(GPXPanel gPXPanel, UnitConverter unitConverter) {
        super(2);
        this.mapPanel = gPXPanel;
        this.uc = unitConverter;
        Dimension dimension = new Dimension(120, 40);
        this.setMinimumSize(new Dimension(100, 12));
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        String string = Integer.toString(this.mapPanel.getZoom());
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        int n = (int)rectangle2D.getWidth();
        double d = this.mapPanel.getMeterPerPixel();
        int n2 = this.getPreferredSize().width - 10 - n;
        Unit unit = this.uc.getTargetSet().getDistanceUnit();
        double d2 = this.uc.convert(this.mapUnit, unit, d * (double)n2);
        Unit unit2 = unit.getNextUnit(d2);
        String string2 = "?";
        String string3 = unit2.getSymbol();
        int n3 = (int)this.uc.convert(unit, unit2, d2);
        for (int i = 0; i < this.scales.length; ++i) {
            if (this.scales[i] > n3) continue;
            string2 = Integer.toString(this.scales[i]) + " " + string3;
            n2 = (int)(this.uc.convert(unit2, this.mapUnit, this.scales[i]) / d);
            break;
        }
        graphics2D.drawLine(0, this.getHeight() - 12, 0, this.getHeight());
        graphics2D.drawLine(0, this.getHeight(), n2, this.getHeight());
        graphics2D.drawLine(n2, this.getHeight() - 12, n2, this.getHeight());
        graphics2D.drawString(string2, 5, this.getHeight() - 5);
        graphics2D.drawString(string, n2 + 5, this.getHeight() - 5);
    }
}

