/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.MapMarkerCircle;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.MapRectangleImpl;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class Demo
extends JFrame
implements JMapViewerEventListener {
    private static final long serialVersionUID = 1L;
    private final JMapViewerTree treeMap;
    private final JLabel zoomLabel;
    private final JLabel zoomValue;
    private final JLabel mperpLabelName;
    private final JLabel mperpLabelValue;

    public Demo() {
        super("JMapViewer Demo");
        this.setSize(400, 400);
        this.treeMap = new JMapViewerTree("Zones");
        this.map().addJMVListener(this);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.mperpLabelName = new JLabel("Meters/Pixels: ");
        this.mperpLabelValue = new JLabel(String.format("%s", this.map().getMeterPerPixel()));
        this.zoomLabel = new JLabel("Zoom: ");
        this.zoomValue = new JLabel(String.format("%s", this.map().getZoom()));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        JLabel jLabel = new JLabel("Use right mouse button to move,\n left double click or mouse wheel to zoom.");
        jPanel4.add(jLabel);
        JButton jButton = new JButton("setDisplayToFitMapMarkers");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.map().setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> jComboBox = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.CycleMap(), new BingAerialTileSource()});
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Demo.this.map().setTileSource((TileSource)itemEvent.getItem());
            }
        });
        JComboBox<TileLoader> jComboBox2 = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader(this.map())});
        jComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Demo.this.map().setTileLoader((TileLoader)itemEvent.getItem());
            }
        });
        this.map().setTileLoader((TileLoader)jComboBox2.getSelectedItem());
        jPanel2.add(jComboBox);
        jPanel2.add(jComboBox2);
        final JCheckBox jCheckBox = new JCheckBox("Map markers visible");
        jCheckBox.setSelected(this.map().getMapMarkersVisible());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.map().setMapMarkerVisible(jCheckBox.isSelected());
            }
        });
        jPanel3.add(jCheckBox);
        final JCheckBox jCheckBox2 = new JCheckBox("Tree Layers visible");
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.treeMap.setTreeVisible(jCheckBox2.isSelected());
            }
        });
        jPanel3.add(jCheckBox2);
        final JCheckBox jCheckBox3 = new JCheckBox("ToolTip visible");
        jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.map().setToolTipText(null);
            }
        });
        jPanel3.add(jCheckBox3);
        final JCheckBox jCheckBox4 = new JCheckBox("Tile grid visible");
        jCheckBox4.setSelected(this.map().isTileGridVisible());
        jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.map().setTileGridVisible(jCheckBox4.isSelected());
            }
        });
        jPanel3.add(jCheckBox4);
        final JCheckBox jCheckBox5 = new JCheckBox("Show zoom controls");
        jCheckBox5.setSelected(this.map().getZoomControlsVisible());
        jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.map().setZoomContolsVisible(jCheckBox5.isSelected());
            }
        });
        jPanel3.add(jCheckBox5);
        final JCheckBox jCheckBox6 = new JCheckBox("Scrollwrap enabled");
        jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Demo.this.map().setScrollWrapEnabled(jCheckBox6.isSelected());
            }
        });
        jPanel3.add(jCheckBox6);
        jPanel3.add(jButton);
        jPanel2.add(this.zoomLabel);
        jPanel2.add(this.zoomValue);
        jPanel2.add(this.mperpLabelName);
        jPanel2.add(this.mperpLabelValue);
        this.add((Component)this.treeMap, "Center");
        LayerGroup layerGroup = new LayerGroup("Germany");
        Layer layer = layerGroup.addLayer("Germany West");
        Layer layer2 = layerGroup.addLayer("Germany East");
        MapMarkerDot mapMarkerDot = new MapMarkerDot(layer2, "Eberstadt", 49.814284999, 8.642065999);
        MapMarkerDot mapMarkerDot2 = new MapMarkerDot(layer, "Ebersheim", 49.91, 8.24);
        MapMarkerDot mapMarkerDot3 = new MapMarkerDot(layer2, 49.71, 8.64);
        MapMarkerDot mapMarkerDot4 = new MapMarkerDot(layer2, "Darmstadt", 49.8588, 8.643);
        this.map().addMapMarker(mapMarkerDot);
        this.map().addMapMarker(mapMarkerDot2);
        this.map().addMapMarker(mapMarkerDot3);
        Layer layer3 = this.treeMap.addLayer("France");
        this.map().addMapMarker(new MapMarkerDot(layer3, "La Gallerie", 48.71, -1.0));
        this.map().addMapMarker(new MapMarkerDot(43.604, 1.444));
        this.map().addMapMarker(new MapMarkerCircle(53.343, -6.267, 0.666));
        this.map().addMapRectangle(new MapRectangleImpl(new Coordinate(53.343, -6.267), new Coordinate(43.604, 1.444)));
        this.map().addMapMarker(mapMarkerDot4);
        this.treeMap.addLayer(layer);
        this.treeMap.addLayer(layer2);
        MapPolygonImpl mapPolygonImpl = new MapPolygonImpl(Demo.c(49.0, 1.0), Demo.c(45.0, 10.0), Demo.c(40.0, 5.0));
        this.map().addMapPolygon(mapPolygonImpl);
        this.map().addMapPolygon(new MapPolygonImpl(layer2, "Riedstadt", mapMarkerDot2, mapMarkerDot4, mapMarkerDot, mapMarkerDot3));
        this.map().addMapMarker(new MapMarkerCircle(layer, "North of Suisse", new Coordinate(48.0, 7.0), 0.5));
        Layer layer4 = this.treeMap.addLayer("Spain");
        this.map().addMapMarker(new MapMarkerCircle(layer4, "La Garena", new Coordinate(40.4838, -3.39), 0.002));
        layer4.setVisible(Boolean.FALSE);
        Layer layer5 = this.treeMap.addLayer("UK");
        this.map().addMapRectangle(new MapRectangleImpl(layer5, "Wales", Demo.c(53.35, -4.57), Demo.c(51.64, -2.63)));
        this.map().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    Demo.this.map().getAttribution().handleAttribution(mouseEvent.getPoint(), true);
                }
            }
        });
        this.map().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                boolean bl = Demo.this.map().getAttribution().handleAttributionCursor(point);
                if (bl) {
                    Demo.this.map().setCursor(new Cursor(12));
                } else {
                    Demo.this.map().setCursor(new Cursor(0));
                }
                if (jCheckBox3.isSelected()) {
                    Demo.this.map().setToolTipText(Demo.this.map().getPosition(point).toString());
                }
            }
        });
    }

    private JMapViewer map() {
        return this.treeMap.getViewer();
    }

    private static Coordinate c(double d, double d2) {
        return new Coordinate(d, d2);
    }

    public static void main(String[] stringArray) {
        new Demo().setVisible(true);
    }

    private void updateZoomParameters() {
        if (this.mperpLabelValue != null) {
            this.mperpLabelValue.setText(String.format("%s", this.map().getMeterPerPixel()));
        }
        if (this.zoomValue != null) {
            this.zoomValue.setText(String.format("%s", this.map().getZoom()));
        }
    }

    @Override
    public void processCommand(JMVCommandEvent jMVCommandEvent) {
        if (jMVCommandEvent.getCommand().equals((Object)JMVCommandEvent.COMMAND.ZOOM) || jMVCommandEvent.getCommand().equals((Object)JMVCommandEvent.COMMAND.MOVE)) {
            this.updateZoomParameters();
        }
    }
}

